% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hierarchicalrule.R
\name{hierarchicalrule}
\alias{hierarchicalrule}
\title{Allocation rule according to the agents' hierarchical order}
\usage{
hierarchicalrule(c, P, rule, a = NULL)
}
\arguments{
\item{c}{A numeric cost vector.}

\item{P}{A list showing the agents involved in the different distribution stages.}

\item{rule}{A character string specifying the rule to apply.The rules that can be selected are:
\code{"SFC"}, \code{"SEC"}, \code{"CEC"}, \code{"CP"}, \code{"CEB"}, \code{"SM"}, \code{"CC"} and \code{"SIGMA"}.}

\item{a}{A numeric value in the range [0,1], controlling the parameterization of the rule. It can only be defined when \code{rule = "SIGMA"}.
By default, \code{a = 0.5}.}
}
\value{
A numeric contribution vector, where each element represents the payment of the different agents.
}
\description{
\code{hierarchicalrule} calculates the contribution vector resulting from the payment allocation among the different agents using one of the various predefined rules in relation to the agents' hierarchical order.
}
\details{
Let \eqn{N=\{1,\dots,n\}} be a finite set of agents and let \eqn{P=\{P_1,\dots,P_{m+1}\}} be a partition
of \eqn{N}, with \eqn{m\leq n-1}. So, the hierarchical structure, \eqn{P_{>}=\{P_1>P_2>\dots>P_m>P_{m+1}\}},
implies that agents in \eqn{P_1} have priority over agents in \eqn{N\backslash P_1}, agents in \eqn{P_2} have priority
over agents in \eqn{N\backslash P_1\cup P_2}, and so on. Let \eqn{\mathcal{P}(N)} denote the family of all hierarchical structures over \eqn{N}.

A hierarchical rule is a mapping \eqn{\mathcal{R}_P:C^N\rightarrow \mathbb{R}^N} that, based on a hierarchical structure \eqn{P_{>}},
associates with each problem \eqn{c\in C^N} a cost allocation vector \eqn{\mathcal{R}_P(c)} such that \eqn{0\leq\mathcal{R}_P(c)\leq c}. In other words, the allocation proceeds by assigning costs
to agents in higher-hierarchy coalitions before those in lower-hierarchy ones, through the successive application of the rule to the no-subsidy faces of coalitions obtained from \eqn{P_{>}}.
These rules are on the boundary of the no-subsidy set.

In each stage, the agents share the accumulated costs up to that point. However, the remaining costs are allocated in subsequent stages.
}
\examples{
# Two stages
c <- c(1, 3, 7, 10) # Cost vector
P <- list(c(1, 2), c(3, 4)) # Agents' hierarchical order
hierarchicalrule(c, P, rule = "SEC") # SEC rule

# Three stages
c <- c(1, 1, 3, 3, 7, 10) # Cost vector
P <- list(2, c(1, 3), c(4, 5, 6)) # Agents' hierarchical order
hierarchicalrule(c, P, "CEC") # CEC rule

}
\references{
Bernárdez Ferradás, A., Mirás Calvo, M. Á., Quinteiro Sandomingo, C., and Sánchez-Rodríguez, E. (2025). Airport problems with cloned agents. [Preprint manuscript].

Faigle, U. and Kern, W. (1992). The Shapley value for cooperation games under precedence constraints.
\emph{International Journal of Game Theory}, 21, 249-266.

Fiestras-Janeiro, M. G., Sánchez-Rodríguez, E., and Schuster, M. (2016). A precedence constraint value revisited.
\emph{TOP}, 24, 156-179.

Mirás Calvo, M. Á., Quinteiro Sandomingo, C., and Sánchez-Rodríguez, E. (2020). The boundary of the core of a balanced game: faces games.
\emph{International Journal of Game Theory}, 49(2), 579-599.
}
\seealso{
\code{\link{NSfaces}}, \code{\link{PRIORrule}}, \code{\link{basicrule}}
}
