% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Models.R
\name{rMKW}
\alias{rMKW}
\title{Modified Kumaraswamy Weibull (MKW) Hazard Function.}
\usage{
rMKW(t, alpha, kappa, eta, log = FALSE)
}
\arguments{
\item{t}{: positive argument}

\item{alpha}{: inverse scale parameter}

\item{kappa}{: shape parameter}

\item{eta}{: shape parameter}

\item{log}{:log scale (TRUE or FALSE)}
}
\value{
the value of the MKW hazard function
}
\description{
Modified Kumaraswamy Weibull (MKW) Hazard Function.
}
\examples{
t=runif(10,min=0,max=1)
rMKW(t=t, alpha=0.35, kappa=0.7, eta=1.4, log=FALSE)

}
\references{
Khosa, S. K. (2019). Parametric Proportional Hazard Models with Applications in Survival analysis (Doctoral dissertation, University of Saskatchewan).
}
\author{
Abdisalam Hassan Muse, Samuel Mwalili, Oscar Ngesa, Christophe Chesneau  \email{abdisalam.hassan@amoud.edu.so}
}
