% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DunnTestNP.R
\name{DunnTest}
\alias{DunnTest}
\title{Dunn's Test for Multiple Comparisons (Non-Parametric)}
\usage{
DunnTest(formula, data, alpha = 0.05, method.p = "holm")
}
\arguments{
\item{formula}{A formula of the form \code{y ~ group}.}

\item{data}{A data frame containing the variables.}

\item{alpha}{Significance level (default is 0.05).}

\item{method.p}{Method for p-value adjustment (default is "holm").}
}
\value{
An object of class \code{"dunn"} and \code{"comparaciones"}, including:
\itemize{
  \item \code{Resultados}: Data frame with group comparisons, z-values, raw and adjusted p-values, and significance.
  \item \code{Promedios}: Mean ranks of each group.
  \item \code{Orden_Medias}: Group names ordered from highest to lowest rank.
  \item \code{Metodo}: "Dunn (no paramétrico)".
}
}
\description{
Performs Dunn's test for pairwise comparisons following a Kruskal-Wallis test.
Suitable for non-parametric data (ordinal or non-normal), using rank sums.
Includes Holm correction by default for multiple comparisons.
}
\details{
Advantages:
- Simple and widely used non-parametric alternative to Tukey's test.
- Handles unequal sample sizes.
- Compatible with various p-value corrections (e.g., Holm, Bonferroni).

Disadvantages:
- Less powerful than DSCF or Conover when sample sizes vary widely.
- Requires ranking all data and can be conservative depending on adjustment.
}
\examples{
data(d_e, package = "Analitica")
DunnTest(Sueldo_actual ~ labor, data = d_e)


}
\references{
Dunn, O. J. (1964). Multiple comparisons using rank sums. *Technometrics*, 6(3), 241–252. \doi{10.1080/00401706.1964.10490181}
}
