% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transition_probs.R
\name{calculate_transition_probs}
\alias{calculate_transition_probs}
\title{Calculate Transition Probabilities from Sequences}
\usage{
calculate_transition_probs(sequences)
}
\arguments{
\item{sequences}{A vector of character strings, where each string represents a sequence of elements separated by spaces.}
}
\value{
A data frame with the following columns:
\item{previous_element}{The element that transitions to the next element.}
\item{element}{The element that follows the previous element.}
\item{count}{The number of times the transition from the previous element to the current element occurs.}
\item{probability}{The probability of transitioning from the previous element to the current element.}
}
\description{
This function calculates the transition probabilities between elements in a set of sequences. It computes the probability of transitioning from one element to another based on the frequency of transitions observed in the input sequences.
}
\details{
The function uses the `unnest_tokens` function from the `tidytext` package to split sequences into individual elements. It then calculates transition counts and probabilities for each pair of consecutive elements in the sequences. The resulting data frame shows the transition probabilities for each possible element pair.
}
\examples{
library(tidytext)
sequences <- c("A B C", "A B", "B C A")
calculate_transition_probs(sequences)
}
