% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_elements.R
\name{cluster_elements}
\alias{cluster_elements}
\title{Cluster Elements Using Hierarchical Clustering}
\usage{
cluster_elements(distance_matrix, method = "complete", plot = TRUE)
}
\arguments{
\item{distance_matrix}{A matrix of distances between elements. Should be a symmetric matrix with row and column names representing elements.}

\item{method}{A character string specifying the method for hierarchical clustering. Options include "complete", "average", "single", etc. Default is "complete".}

\item{plot}{A logical value indicating whether to plot the dendrogram. Default is TRUE.}
}
\value{
An object of class \code{"hclust"} representing the hierarchical clustering result.
}
\description{
This function performs hierarchical clustering on a distance matrix and optionally plots the dendrogram. It uses the specified method for clustering and can visualize the results.
}
\details{
Hierarchical clustering is performed using the specified method. If \code{plot} is TRUE, the function will generate a dendrogram to visualize the clustering.
}
\examples{
# Create a distance matrix
distance_matrix <- dist(matrix(rnorm(20), nrow = 5))

# Perform hierarchical clustering and plot the dendrogram
cluster_elements(distance_matrix, method = "complete", plot = TRUE)

}
