% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequence_length_summary.R
\name{compare_distinct_elements_per_list_item}
\alias{compare_distinct_elements_per_list_item}
\title{Compare True and Shuffled Distinct Elements per List Item}
\usage{
compare_distinct_elements_per_list_item(sequences, iterations = 100)
}
\arguments{
\item{sequences}{A list of character vectors, where each vector contains sequences of elements separated by spaces.}

\item{iterations}{An integer specifying the number of shuffling iterations.}
}
\value{
A data frame with columns:
\item{true_distinct_elements}{The number of distinct elements per list item in the original sequences.}
\item{shuffled_distinct_elements}{The average number of distinct elements per list item in shuffled sequences.}
\item{p_value}{The p-value representing the proportion of shuffled sequences where the number of distinct elements is less than or equal to the true number.}
}
\description{
This function compares the true number of distinct elements per list item in a list of sequences to the number of distinct elements per list item in shuffled sequences. The comparison is done by calculating p-values from shuffled sequences.
}
\examples{
sequences <- c('hello world', 'hello world hello', 'hello world hello world', 'hello world')
compare_distinct_elements_per_list_item(sequences, iterations = 100)
}
