% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_elements_experimental.R
\name{perform_clustering}
\alias{perform_clustering}
\title{Perform Various Clustering Methods}
\usage{
perform_clustering(data, n_clusters = 3)
}
\arguments{
\item{data}{A numeric matrix or data frame where rows represent observations and columns represent features.}

\item{n_clusters}{An integer specifying the number of clusters for methods that require it (e.g., K-means, hierarchical clustering). Default is 3.}
}
\value{
A list with clustering results for each method:
\item{kmeans}{A list containing the results of K-means clustering, including cluster assignments.}
\item{hierarchical}{A vector of cluster assignments from hierarchical clustering.}
\item{dbscan}{A vector of cluster assignments from DBSCAN.}
\item{gmm}{A vector of cluster assignments from Gaussian Mixture Model (GMM).}
\item{spectral}{A vector of cluster assignments from spectral clustering.}
\item{affinity_propagation}{A list of clusters from affinity propagation.}
}
\description{
This function performs multiple clustering methods on the input data and returns the results. The methods include K-means, hierarchical clustering, DBSCAN, Gaussian Mixture Model (GMM), spectral clustering, and affinity propagation.
}
\details{
- **K-means**: Performs K-means clustering with the specified number of clusters.
- **Hierarchical clustering**: Performs hierarchical clustering and cuts the dendrogram to create the specified number of clusters.
- **DBSCAN**: Applies DBSCAN clustering with predefined parameters.
- **Gaussian Mixture Model (GMM)**: Uses the Mclust package to perform GMM clustering.
- **Spectral clustering**: Uses the kernlab package to perform spectral clustering with a kernel matrix.
- **Affinity propagation**: Uses the apcluster package to perform affinity propagation clustering.
}
\examples{
# Generate sample data
data <- matrix(rnorm(100), nrow = 10)

# Perform clustering
clustering_results <- perform_clustering(data, n_clusters = 3)

# Access the results
clustering_results$kmeans
clustering_results$hierarchical
clustering_results$dbscan
clustering_results$gmm
clustering_results$spectral
clustering_results$affinity_propagation

}
