% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequence_length_summary_covariate.R
\name{sequence_length_summary_covariate}
\alias{sequence_length_summary_covariate}
\title{Summarize Sequence Lengths by Covariate}
\usage{
sequence_length_summary_covariate(sequences, covariate)
}
\arguments{
\item{sequences}{A character vector where each element is a sequence of elements separated by spaces.}

\item{covariate}{A vector of covariates with the same length as `sequences`, used to group the sequences.}
}
\value{
A data frame with the following columns:
\item{covariate}{The value of the covariate.}
\item{mean_seq_elements}{The mean length of sequences for this covariate value.}
\item{sd_seq_elements}{The standard deviation of the sequence lengths for this covariate value.}
\item{median_seq_elements}{The median length of sequences for this covariate value.}
\item{min_seq_elements}{The minimum length of sequences for this covariate value.}
\item{max_seq_elements}{The maximum length of sequences for this covariate value.}
\item{distinct_elements}{The number of distinct elements for this covariate value.}
\item{pvalue_distinct_elements}{The p-value comparing the number of distinct elements to shuffled sequences for this covariate value.}
}
\description{
This function calculates summary statistics for the lengths of sequences of elements, grouped by a specified covariate. It includes mean, standard deviation, median, minimum, and maximum lengths, along with the number of distinct elements and the p-value comparing to shuffled sequences.
}
\examples{
sequences <- c('hello world', 'hello world hello', 'hello world hello world')
covariate <- c('A', 'B', 'A')
sequence_length_summary_covariate(sequences, covariate)
}
