% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Af_cluster_node_features.R
\name{Af_cluster_node_features}
\alias{Af_cluster_node_features}
\title{Function to create a barplot of the cluster composition of selected features from each tree in an AntibodyForests-object}
\usage{
Af_cluster_node_features(
  input,
  features,
  clusters,
  fill,
  colors,
  text.size,
  significance
)
}
\arguments{
\item{input}{AntibodyForests-object(s), output from Af_build()}

\item{features}{Character vector of features to include in the barplot. (these features need to be present in the nodes of the trees)}

\item{clusters}{Named vector with the cluster assignments of the trees, output from Af_compare_within_repertoires().}

\item{fill}{identify each unique feature per tree (unique, default), or assign the most observed feature to the tree (max)}

\item{colors}{Color palette to use for the features.}

\item{text.size}{Size of the text in the plot. Default is 12.}

\item{significance}{Logical, whether to add Chi-squared Test p-value to the plot. Default is FALSE.}
}
\value{
A list with barplots for each provided feature.
}
\description{
Function to create a barplot of the cluster composition of selected features from each tree in an AntibodyForests-object
}
\examples{
plot <- Af_cluster_node_features(input = AntibodyForests::small_af,
                                 clusters = AntibodyForests::compare_repertoire[["clustering"]],
                                 features = "isotype",
                                 fill = "max")
plot$isotype
}
