% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ApacheLogProcessor.R
\name{parse.php.msgs}
\alias{parse.php.msgs}
\title{Parses PHP mesages and store its parts in a data frame that contains level, message, file, line number and referer.}
\usage{
parse.php.msgs(dfErrorLog)
}
\arguments{
\item{dfErrorLog}{Error log load with the read.apache.error.log or read.multiple.apache.error.log functions.}
}
\value{
a data frame with PHP error message split in parts.
}
\description{
Parses PHP mesages and store its parts in a data frame that contains level, message, file, line number and referer.
}
\examples{

#Loads the path of the erro log
path <- system.file("examples", "error_log.log", package = "ApacheLogProcessor")

#Loads the error log to a data frame
dfELog <- read.apache.error.log(path)

dfPHPMsgs <- parse.php.msgs(dfELog)


}
