% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Counter.R
\name{newCounter}
\alias{newCounter}
\title{Create a logger of the Counter class}
\arguments{
\item{name}{the name of the counter, must be a length-1 character vector}

\item{from}{a list specifying state of the agent, or a character or numeric
value that is equivalent to list(from). please see the details section}

\item{to}{a list (can be NULL) specifying the state of the agent after the
state change, or a character or numeric value that is equivalent to
list(from). please see the details section}

\item{initial}{the initial value of the counter. Default to 0.}
}
\value{
an external pointer that can be passed to the \link{Simulation} class'
\verb{$addLogger}.
}
\description{
When state changes occur, it is passed to each logger, which then
change its value. At the specified time points in a run, the
values of the logger are reported and recorded in a data.frame object,
where the columns represent variables, and rows represent the
observation at each time point given to each run. Each logger has a
name, which becomes the the column name in the data.frame.
}
\details{
if the argument "to" is not NULL, then the counter counts the
transitions from "from" to "to". Otherwise, it counts the number of agents
in a state that matches the "from" argument. Specifically, if the agent
jumps to "from", then the count increases by 1. If the agents jumps away
from "from", then the count decreases by 1.
}
