% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AFMNetworksAnalyser.R
\docType{methods}
\name{getNetworkParameters}
\alias{getNetworkParameters}
\alias{getNetworkParameters,AFMImageNetworksAnalysis-method}
\alias{getNetworkParameters,AFMImage-method}
\title{Get Network parameters}
\usage{
getNetworkParameters(AFMImageNetworksAnalysis, AFMImage)


  \S4method{getNetworkParameters}{AFMImageNetworksAnalysis}(AFMImageNetworksAnalysis,
  AFMImage)
}
\arguments{
\item{AFMImageNetworksAnalysis}{an \code{\link{AFMImageNetworksAnalysis}}}

\item{AFMImage}{an \code{\link{AFMImage}}}
}
\value{
a data.table of network parameters: 
\itemize{
  \item totalNumberOfNodes the total number of nodes with degree different of 2
  \item totalNumberOfNodesWithDegreeTwoOrMore  the total number of nodes with degree 2 or more
  \item totalNumberOfNodesWithDegreeOne the total number of nodes with degree one
  \item numberOfNodesPerArea  the total number of nodes with degree diffrent of 2 per area
  \item numberOfNodesPerSurfaceArea the total number of nodes with degree diffrent of 2 per surface area
  \item MeanPhysicalDistanceBetweenNodes the mean physical distance between nodes of degree different of two
}
}
\description{
Get basic network parameters :
Total root mean square Roughness or Total Rrms or totalRMSRoughness_TotalRrms\cr
Mean roughness or Ra or MeanRoughness_Ra
}
\details{
\code{getNetworkParameters} returns a data.table of network parameters
}
\examples{
\dontrun{
library(AFM)
library(parallel)

# dir = ""
# filename= ""
AFMImage<-importFromNanoscope(paste0(dir,filename))
AFMImageNetworksAnalysis = new("AFMImageNetworksAnalysis")
AFMImageNetworksAnalysis@heightNetworksslider=10
AFMImageNetworksAnalysis@filterNetworkssliderMin=150
AFMImageNetworksAnalysis@filterNetworkssliderMax=300
AFMImageNetworksAnalysis@smallBranchesTreatment=TRUE
AFMImageNetworksAnalysis<-transformAFMImageForNetworkAnalysis(AFMImageNetworksAnalysis, AFMImage)
numWorkers <- parallel::detectCores()
cl <- makeCluster(numWorkers,outfile="")
AFMImageNetworksAnalysis<-identifyNodesWithCircles(cl=cl, 
    AFMImageNetworksAnalysis= AFMImageNetworksAnalysis)
AFMImageNetworksAnalysis<-identifyEdgesFromCircles(cl=cl,
    AFMImageNetworksAnalysis= AFMImageNetworksAnalysis,
    MAX_DISTANCE = 40)
AFMImageNetworksAnalysis<-identifyIsolatedNodes(AFMImageNetworksAnalysis)
AFMImageNetworksAnalysis<-createGraph(AFMImageNetworksAnalysis, fusioned=FALSE)
AFMImageNetworksAnalysis<-calculateShortestPaths(cl=cl,
    AFMImageNetworksAnalysis= AFMImageNetworksAnalysis)
stopCluster(cl)
networkParameters<-getNetworkParameters(AFMImageNetworksAnalysis, AFMImage)
print(networkParameters)
}
}
\author{
M.Beauvais
}
