% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{legacy_parse_primary_accelerometerC}
\alias{legacy_parse_primary_accelerometerC}
\alias{dev_parse_primary_accelerometerC}
\title{Parse all primary accelerometer packets in a file}
\usage{
legacy_parse_primary_accelerometerC(
  primary_records,
  log,
  scale_factor,
  samp_rate,
  verbose
)

dev_parse_primary_accelerometerC(
  packets,
  packet_no,
  zero_packet,
  samp_rate,
  scale_factor
)
}
\arguments{
\item{primary_records}{DataFrame with information about each packet}

\item{log}{RawVector containing all payload bytes}

\item{scale_factor}{the accelerometer scale factor}

\item{samp_rate}{the sampling rate}

\item{verbose}{logical. Print updates to console?}

\item{packets}{list of packets}

\item{packet_no}{IntegerVector indicating which index of \code{packets} to
use for each second of expected output. Values of -1 indicate a latch to
the previous index}

\item{zero_packet}{list containing a properly-formatted packet pre-filled
with values of zero (used for USB connection events)}

\item{latch_packets}{list of empty packets to be filled during latch periods}
}
\description{
Parse all primary accelerometer packets in a file
}
\keyword{internal}
