# Setup -------------------------------------------------------------------

  imu_1s <- read_AG_IMU(
    system.file(
      "extdata", "example-IMU.csv", package = "AGread"
    ),
    output_vars = c("gyroscope", "magnetometer")
  )[ ,-2]

  imu_5s <- suppressMessages(read_AG_IMU(
    system.file(
      "extdata", "example-IMU.csv", package = "AGread"
    ), 5,
    output_vars = c("gyroscope", "magnetometer")
  )[ ,-2])


# Testing -----------------------------------------------------------------

## Using `expect_equal` because snapshots were failing inexplicably

  test_that("File reading produces expected output", {

    testthat::expect_equal(
      imu_1s,
      structure(
        list(
          file_source_IMU = rep(
            "example-IMU.csv", 23
          ),
          Timestamp = structure(
            1550134680:1550134702, class = c("POSIXct", "POSIXt"), tzone = "UTC"
          ),
          Gyroscope_VM_DegPerS = c(
            0.81727464263916, 0.796904816239577, 0.832365444075677,
            0.826904716905923, 0.819911933079361, 0.825183270501077,
            0.812165282677925, 0.834704377840904, 0.822579328077043,
            0.811547142591012, 0.81441318492422, 0.819363593833386,
            0.823804103397773, 0.824845807258063, 0.833602183445514,
            0.819944437557608, 0.820997744612959, 0.817825624106993,
            0.825186514799276, 0.817809254748172, 0.815492064118194,
            0.818969893310862, 0.817915461703354
          ),
          mean_abs_Gyroscope_x_DegPerS = c(
            0.759812114404147, 0.742886792679309, 0.77262969008082,
            0.77196057016752, 0.7652949267117, 0.772244310927278,
            0.764835377490974, 0.781997200979187, 0.772117322560529,
            0.760537884068085, 0.765326773768983, 0.770870654718418,
            0.778840719513091, 0.776914971353799, 0.786132408128639,
            0.77858616653284, 0.779723719053592, 0.772449187805388,
            0.781379168541423, 0.778402991975727, 0.774126392954325,
            0.777779066714882, 0.776467037747456
          ),
          mean_abs_Gyroscope_y_DegPerS = c(
            0.268329789940164, 0.263595221142547, 0.278537744211907,
            0.266116408258182, 0.265303979760367, 0.260304482013826,
            0.235984229296259, 0.262481782683943, 0.25142395729946,
            0.25267039350811, 0.251257488661755, 0.246525883707042,
            0.232770130344574, 0.240576731914146, 0.241974030957657,
            0.226688403213473, 0.221493318692539, 0.235678889786825,
            0.233275857298277, 0.221356805090016, 0.227636205720119,
            0.230086098575458, 0.228293234057756
          ),
          mean_abs_Gyroscope_z_DegPerS = c(
            0.110515141352101, 0.101239339736629, 0.0979826010898158,
            0.102425958590037, 0.10993961686369, 0.102613044203254,
            0.104245345795978, 0.112557154594847, 0.114440519653899,
            0.114954690701363, 0.108595435407611, 0.111826809815375,
            0.118259739001215, 0.121621919926943, 0.120224002750698,
            0.106196216216621, 0.113038021355806, 0.109771928145205,
            0.110024161217707, 0.0969749576905418, 0.101266613854747,
            0.0971060539595554, 0.101572992575065
          ),
          mean_magnetometer_direction = rep(
            "SE", 23
          )
        ),
        class = "data.frame",
        row.names = c(NA, -23L)
      )
    )

    testthat::expect_equal(
      imu_5s,
      structure(
        list(
          file_source_IMU = rep(
            "example-IMU.csv", 4
          ),
          Timestamp = structure(
            seq(1550134680, 1550134695, 5),
            class = c("POSIXct", "POSIXt"),
            tzone = "UTC"
          ),
          Gyroscope_VM_DegPerS = c(
            0.81867231058794, 0.821235880337592,
            0.823205774571791, 0.820352715165002
          ),
          mean_abs_Gyroscope_x_DegPerS = c(
            0.762516818808699, 0.770346419205211,
            0.775617105496586, 0.778108246781794
          ),
          mean_abs_Gyroscope_y_DegPerS = c(
            0.268376628662633, 0.252572968960319,
            0.242620853117035, 0.227698654816226
          ),
          mean_abs_Gyroscope_z_DegPerS = c(
            0.104420531526455, 0.109762150989868,
            0.116105581380369, 0.107201056925176
          ),
          mean_magnetometer_direction = rep(
            "SE", 4
          )
        ),
        class = "data.frame",
        row.names = c(NA,-4L)
      )
    )

  })
