% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AHPtools.R
\name{viewAHPtree}
\alias{viewAHPtree}
\title{Create AHP Tree Structure}
\usage{
viewAHPtree(ahp)
}
\arguments{
\item{ahp}{A data frame with the AHP structure including Node and Parent columns}
}
\value{
A `Node` object (from the `data.tree` package) representing the full AHP tree
}
\description{
Builds a hierarchical tree from a flat AHP representation.
}
\details{
For an overview and examples, please see the associated vignette:
`vignette("viewAHPtree", package = "AHPtools")`
}
\examples{
file <- system.file("extdata", "example_transport.xlsx", package = "AHPtools")
AHPstruc <- readxl::read_excel(file, sheet = "ahp")
tree <- viewAHPtree(AHPstruc)
print(tree, "level", limit=NULL)
}
