% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ahr.R
\name{ahrKM}
\alias{ahrKM}
\title{ahrKM}
\usage{
ahrKM(L, formula, data, null.theta = NULL, contrast = NULL,
  multi.test = FALSE, cov = TRUE, bootstrap = 0, left.limit = FALSE)
}
\arguments{
\item{L}{time-limit specifying time-interval [0,L] over which average hazard ratios will be calculated}

\item{formula}{an object of class '"formula"' specifying the conditional survival model}

\item{data}{data frame containing the variables in formula}

\item{null.theta}{vector specifying the null hypothesis for the average hazard ratios (H_0: theta = null.theta)}

\item{contrast}{vector of contrasts to test H_0: contrast * (theta - null.theta) = 0}

\item{multi.test}{calculate multivariate test statistic if TRUE}

\item{cov}{if TRUE calculate covariance matrix estimator (direct)}

\item{bootstrap}{if > 0 then use bootstrap to estimate covariance matrix (ignore if cov is TRUE)}

\item{left.limit}{if TRUE use left-continuous interpolation of WKM estimates}
}
\value{
An object of class '"ahr"'
}
\description{
Estimate average hazard ratios from k independent samples based on the Kaplan-Meier estimator
}
\examples{
T <- c(rexp(100, 1), rexp(100, 2))
C <- c(rexp(100, 1), rexp(100, 2))
Y <- pmin(T, C)
D <- T <= C
Z <- rep(c(0,1), c(100, 100)) # treatment indicator
fit <- ahrKM(2, Surv(Y, D) ~ Z, data.frame(Y=Y, D=D, Z=Z))
fit

## the same as above, but estimate covariance matrix using bootstrap
\dontrun{fitBS <- ahrKM(2, Surv(Y, D) ~ Z, data.frame(Y=Y, D=D, Z=Z), cov=FALSE,
                         bootstrap=1000)}
}
\references{
J.~D. Kalbfleisch and R.~L. Prentice. Estimation of the average hazard ratio. \emph{Biometrika}, 68(1):105--112, Apr. 1981.
}
\seealso{
\code{\link{survfit}}
}

