% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screen_errors.R
\name{screen_errors}
\alias{screen_errors}
\title{Generic function to re-screen failed title and abstract requests.}
\usage{
screen_errors(
  object,
  api_key = get_api_key(),
  max_tries = 4,
  max_seconds,
  is_transient,
  backoff,
  after,
  ...
)
}
\arguments{
\item{object}{An object of either class \code{'gpt'} or \code{'chatgpt'}.}

\item{api_key}{Numerical value with your personal API key. Default setting draws
on the \code{\link[=get_api_key]{get_api_key()}} to retrieve the API key from the R environment, so that the key is not
compromised. The API key can be added to the R environment via \code{\link[=set_api_key]{set_api_key()}}
or by using \code{\link[usethis:edit]{usethis::edit_r_environ()}}. In the \code{.Renviron} file, write \code{CHATGPT_KEY=INSERT_YOUR_KEY_HERE}.
After entering the API key, close and save the \code{.Renviron} file and restart \code{RStudio} (ctrl + shift + F10).
Alternatively, one can use \code{\link[httr2:secrets]{httr2::secret_make_key()}}, \code{\link[httr2:secrets]{httr2::secret_encrypt()}}, and
\code{\link[httr2:secrets]{httr2::secret_decrypt()}} to scramble and decrypt the API key.}

\item{max_tries, max_seconds}{'Cap the maximum number of attempts with
\code{max_tries} or the total elapsed time from the first request with
\code{max_seconds}. If neither option is supplied (the default), \code{\link[httr2:req_perform]{httr2::req_perform()}}
will not retry' (Wickham, 2023). Default \code{max_tries} is 16. If missing, the value of \code{max_seconds}
from the original screening conducted with \code{\link[=tabscreen_gpt]{tabscreen_gpt()}} will be used.}

\item{is_transient}{'A predicate function that takes a single argument
(the response) and returns \code{TRUE} or \code{FALSE} specifying whether or not
the response represents a transient error' (Wickham, 2023). If missing, the \code{is_transient}
function from the original screening conducted with \code{\link[=tabscreen_gpt]{tabscreen_gpt()}} will be used.}

\item{backoff}{'A function that takes a single argument (the number of failed
attempts so far) and returns the number of seconds to wait' (Wickham, 2023).
If missing, the \code{backoff}value from the original screening conducted with \code{\link[=tabscreen_gpt]{tabscreen_gpt()}} will be used.}

\item{after}{'A function that takes a single argument (the response) and
returns either a number of seconds to wait or \code{NULL}, which indicates
that a precise wait time is not available that the \code{backoff} strategy
should be used instead' (Wickham, 2023). If missing, the \code{after} value
from the original screening conducted with \code{\link[=tabscreen_gpt]{tabscreen_gpt()}} will be used.}

\item{...}{Further argument to pass to the request body. See \url{https://platform.openai.com/docs/api-reference/chat/create}.
If used in the original screening in \code{\link[=tabscreen_gpt]{tabscreen_gpt()}}, the argument(s)
must be specified here again.}
}
\value{
An object of class \code{'gpt'} or \code{'chatgpt'} similar to the object returned by \code{\link[=tabscreen_gpt]{tabscreen_gpt()}}.
See documentation for \code{\link[=tabscreen_gpt]{tabscreen_gpt()}}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}\if{html}{\out{<br>}}
\if{html}{\out{<br>}}

This is a generic function to re-screen of failed title and abstract requests.
}
\examples{

\dontrun{

set_api_key()
prompt <- "Is this study about a Functional Family Therapy (FFT) intervention?"

obj_with_error <-
  tabscreen_gpt(
    data = filges2015_dat[1:2,],
    prompt = prompt,
    studyid = studyid,
    title = title,
    abstract = abstract,
    model = "gpt-4o-mini"
    )

obj_rescreened <-
  obj_with_error |>
  screen_error()

}

}
\seealso{
\code{\link[=screen_errors.gpt]{screen_errors.gpt()}}, \code{\link[=screen_errors.chatgpt]{screen_errors.chatgpt()}}
}
