% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screen_errors.orginal.R
\name{screen_errors.chatgpt}
\alias{screen_errors.chatgpt}
\title{Re-screen failed requests.}
\usage{
\method{screen_errors}{chatgpt}(
  object,
  ...,
  api_key = get_api_key(),
  max_tries = 4,
  max_seconds,
  is_transient,
  backoff,
  after
)
}
\arguments{
\item{object}{An object of class \code{'chatgpt'}.}

\item{...}{Further argument to pass to the request body.
See \url{https://platform.openai.com/docs/api-reference/chat/create}.
If used in the original screening (e.g., with \code{\link[=tabscreen_gpt.original]{tabscreen_gpt.original()}}), the argument(s)
must be specified again here.}

\item{api_key}{Numerical value with your personal API key.}

\item{max_tries, max_seconds}{'Cap the maximum number of attempts with
\code{max_tries} or the total elapsed time from the first request with
\code{max_seconds}. If neither option is supplied (the default), \code{\link[httr2:req_perform]{httr2::req_perform()}}
will not retry' (Wickham, 2023). Default \code{max_tries} is 4. If missing, the value of \code{max_seconds}
from the original screening (e.g., conducted with \code{\link[=tabscreen_gpt.original]{tabscreen_gpt.original()}}) will be used.}

\item{is_transient}{'A predicate function that takes a single argument
(the response) and returns \code{TRUE} or \code{FALSE} specifying whether or not
the response represents a transient error' (Wickham, 2023). If missing, the \code{is_transient}
function from the original screening (e.g., conducted with \code{\link[=tabscreen_gpt.original]{tabscreen_gpt.original()}}) will be used.}

\item{backoff}{'A function that takes a single argument (the number of failed
attempts so far) and returns the number of seconds to wait' (Wickham, 2023).
If missing, the \code{backoff}value from the original screening (e.g., conducted
with \code{\link[=tabscreen_gpt.original]{tabscreen_gpt.original()}}) will be used.}

\item{after}{'A function that takes a single argument (the response) and
returns either a number of seconds to wait or \code{NULL}, which indicates
that a precise wait time is not available that the \code{backoff} strategy
should be used instead' (Wickham, 2023). If missing, the \code{after} value
from the original screening (e.g., conducted with \code{\link[=tabscreen_gpt.original]{tabscreen_gpt.original()}}) will be used.}
}
\value{
Object of class \code{'chatgpt'} similar to the object returned by \code{\link[=tabscreen_gpt.original]{tabscreen_gpt.original()}}.
See documentation value for \code{\link[=tabscreen_gpt.original]{tabscreen_gpt.original()}}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}\if{html}{\out{<br>}}
\if{html}{\out{<br>}}

This function supports re-screening of all failed title and abstract requests
screened with \code{\link[=tabscreen_gpt.original]{tabscreen_gpt.original()}}. This function has been deprecated because
OpenAI has deprecated the function_call and and functions argument that was used
in \code{\link[=tabscreen_gpt.original]{tabscreen_gpt.original()}}.
}
\examples{

\dontrun{

set_api_key()

prompt <- "Is this study about a Functional Family Therapy (FFT) intervention?"

obj_with_error <-
  tabscreen_gpt(
    data = filges2015_dat[1:2,],
    prompt = prompt,
    studyid = studyid,
    title = title,
    abstract = abstract,
    model = c("gpt-3.5-turbo-0613", "gpt-3.5-turbo-16k-0613"),
    max_tries = 1,
    reps = 10
    )

obj_rescreened <-
  obj_with_error |>
  screen_error()

# Alternatively re-set max_tries if errors still appear
obj_rescreened <-
  obj_with_error |>
  screen_error(max_tries = 16)
}

}
\references{
Wickham H (2023).
\emph{httr2: Perform HTTP Requests and Process the Responses}.
https://httr2.r-lib.org, https://github.com/r-lib/httr2.
}
\seealso{
\code{\link[=tabscreen_gpt.original]{tabscreen_gpt.original()}}
}
