% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Butterfly.R
\docType{methods}
\name{butterfly}
\alias{butterfly}
\title{Identify butterflies from a VoxelSpace object.}
\usage{
butterfly(vxsp)
}
\arguments{
\item{vxsp}{a \code{\linkS4class{VoxelSpace}} object}
}
\value{
a list of voxel index (i, j, k) identified as butterfly.
}
\description{
Identify butterflies from a \code{\linkS4class{VoxelSpace}} object.

A butterfly refers to a non-empty isolated voxel. Non-empty means that there
is one or more hits recorded in the voxel. Isolated means that voxels in the
\href{https://en.wikipedia.org/wiki/Moore_neighborhood}{Moore neighborhood}
of rank 1 are empty (no hit).
}
\examples{
# load a voxel file
vxsp <- readVoxelSpace(system.file("extdata", "tls_sample.vox", package = "AMAPVox"))
# identify butterflies
btf <- butterfly(vxsp)
# clear butterflies
clear(vxsp, butterfly(vxsp))
}
\seealso{
\code{\link[=clear]{clear()}}
}
