% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsi_analysis.R
\name{rsi_predict}
\alias{rsi_predict}
\title{Predict antimicrobial resistance}
\usage{
rsi_predict(tbl, col_ab, col_date,
  year_max = as.integer(format(as.Date(Sys.Date()), "\%Y")) + 15,
  year_every = 1, model = "binomial", I_as_R = TRUE,
  preserve_measurements = TRUE, info = TRUE)
}
\arguments{
\item{tbl}{table that contains columns \code{col_ab} and \code{col_date}}

\item{col_ab}{column name of \code{tbl} with antimicrobial interpretations (\code{R}, \code{I} and \code{S}), supports tidyverse-like quotation}

\item{col_date}{column name of the date, will be used to calculate years if this column doesn't consist of years already, supports tidyverse-like quotation}

\item{year_max}{highest year to use in the prediction model, deafults to 15 years after today}

\item{year_every}{unit of sequence between lowest year found in the data and \code{year_max}}

\item{model}{the statistical model of choice. Valid values are \code{"binomial"} (or \code{"binom"} or \code{"logit"}) or \code{"loglin"} or \code{"linear"} (or \code{"lin"}).}

\item{I_as_R}{treat \code{I} as \code{R}}

\item{preserve_measurements}{overwrite predictions of years that are actually available in the data, with the original data. The standard errors of those years will be \code{NA}.}

\item{info}{print textual analysis with the name and \code{\link{summary}} of the model.}
}
\value{
\code{data.frame} with columns \code{year}, \code{probR}, \code{se_min} and \code{se_max}.
}
\description{
Create a prediction model to predict antimicrobial resistance for the next years on statistical solid ground. Standard errors (SE) will be returned as columns \code{se_min} and \code{se_max}. See Examples for a real live example.
}
\examples{
\dontrun{
# use it directly:
rsi_predict(tbl = tbl[which(first_isolate == TRUE & genus == "Haemophilus"),],
            col_ab = "amcl", col_date = "date")
  
# or with dplyr so you can actually read it:
library(dplyr)
tbl \%>\%
  filter(first_isolate == TRUE,
         genus == "Haemophilus") \%>\%
  rsi_predict(amcl, date)
}


# real live example:
library(dplyr)
septic_patients \%>\%
  # get bacteria properties like genus and species
  left_join_bactlist("bactid") \%>\% 
  # calculate first isolates
  mutate(first_isolate = 
           first_isolate(.,
                         "date",
                         "patient_id",
                         "genus",
                         "species",
                         col_specimen = NA,
                         col_icu = NA)) \%>\% 
  # filter on first E. coli isolates
  filter(genus == "Escherichia", 
         species == "coli", 
         first_isolate == TRUE) \%>\%
  # predict resistance of cefotaxime for next years
  rsi_predict(col_ab = cfot,
              col_date = date,
              year_max = 2025,
              preserve_measurements = FALSE)

}
\seealso{
\code{\link{lm}} \cr \code{\link{glm}}
}
