% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apa_list.R
\name{apa_add_agg_class}
\alias{apa_add_agg_class}
\title{Add aggregation classes to an \code{apa_list}}
\usage{
apa_add_agg_class(
  apa_list,
  agg_class_column = NULL,
  apa_polygon = attr(apa_list, "apa_config")$apa_polygon
)
}
\arguments{
\item{apa_list}{A \code{apa_list}-object that was created with the
[apa_list]-function.}

\item{agg_class_column}{A vector of column names in \code{apa_list$tree_dat}
that specify variables that are used as additional grouping variable.}

\item{apa_polygon}{logical, specifies if \code{POLYGON}s of APA-patches be
should be added.}
}
\description{
Additional grouping variables are added to an \code{apa_list} (for example
tree species information). All APA-properties will be aggregated for these
classes as well.
}
