% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KL.r
\name{KL}
\alias{KL}
\title{KL function
APR suggest this measure to assess the "plausibility" of the conditional forecast.
It is based on the Kullback-Leibler measure of distance between the unconditional forecast and the
conditional/scenario forecast.}
\usage{
KL(Sigma_eps, mu_eps, h, plot_ = FALSE, max_cores = NULL)
}
\arguments{
\item{Sigma_eps}{variance of innovation}

\item{mu_eps}{mean of innovation}

\item{h}{forecast horizon}

\item{plot_}{logical; if TRUE then a histogram of the KL measure is returned}

\item{max_cores}{maximum number of cores to use for parallel processing (default: NULL, uses CRAN-compliant detection with Windows=1)}
}
\value{
Returns the APR 'q': ie distance from a fair binomial distribution
}
\description{
KL function
APR suggest this measure to assess the "plausibility" of the conditional forecast.
It is based on the Kullback-Leibler measure of distance between the unconditional forecast and the
conditional/scenario forecast.
}
\examples{
# Example with simulated innovation data
# Set dimensions
n_var <- 3
h <- 4
n_draws <- 10
n_innovations <- n_var * h

# Create simulated innovation means and covariances
set.seed(123)
mu_eps <- array(rnorm(n_innovations * 1 * n_draws, mean = 0, sd = 0.1), 
                dim = c(n_innovations, 1, n_draws))

Sigma_eps <- array(0, dim = c(n_innovations, n_innovations, n_draws))
for (d in 1:n_draws) {
  temp_cov <- matrix(rnorm(n_innovations^2), n_innovations, n_innovations)
  Sigma_eps[,,d] <- temp_cov \%*\% t(temp_cov) + diag(n_innovations) * 0.5
}

# Calculate KL measure
kl_result <- KL(Sigma_eps, mu_eps, h, plot_ = FALSE)
print(head(kl_result[[1]]))  # Print first few q values

}
