% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crit_val_bounds_sim.R
\name{f_test_custom}
\alias{f_test_custom}
\title{F-test of regression's overall significance}
\usage{
f_test_custom(dep_var, indep_vars, model_res, const = TRUE)
}
\arguments{
\item{dep_var}{A numeric vector or a matrix with one column representing the
dependent variable.}

\item{indep_vars}{A matrix representing the independent variables.}

\item{model_res}{A numeric vector representing the regression's residuals.}

\item{const}{A logical indicating whether the constant term should be
restricted too.}
}
\value{
\code{f_test_custom} returns a list containing the F-statistic and
  the numerator's degrees of freedom.
}
\description{
\code{f_test_custom} performs an overall significance F-test on a regression.
It is used along with \code{\link[stats]{.lm.fit}} to get the F-statistic as
this is about 10 times faster than extracting it from a regression using
\code{\link[stats]{lm}}.
}
\seealso{
\code{\link{vcov_custom}} \code{\link{f_bounds_sim}}
  \code{\link{t_bounds_sim}}independent
}
\author{
Kleanthis Natsiopoulos, \email{klnatsio@gmail.com}
}
\keyword{internal}
