% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selections.R
\name{calc_selection_weights}
\alias{calc_selection_weights}
\title{Calculate Selection Weights}
\usage{
calc_selection_weights(
  meta_sun,
  params,
  col_site_id = site_id,
  col_min = t2sr,
  col_day = date
)
}
\arguments{
\item{meta_sun}{(Spatial) Data frame. Recording meta data with time to
sunrise/sunset. Output of \code{calc_sun()}. Must have at least \code{col_min},
\code{col_day}, and \code{col_site_id}.}

\item{params}{Named list. Parameters created by \code{sim_selection_weights()}, containing
\code{min_range}, \code{min_mean}, \code{min_sd}, \code{day_range}, \code{day_mean}, \code{day_sd},
\code{offset}, \code{return_log}, \code{selection_fun}.}

\item{col_site_id}{Column. Unquoted column containing site strata IDs
(defaults to \code{site_id}).}

\item{col_min}{Column. Unquoted column containing minutes to sunrise (\code{t2sr})
or sunset (\code{t2ss}) output from \code{calc_sun()} (defaults to \code{t2sr}).}

\item{col_day}{Column. Unquoted column containing dates or day-of-year (doy)
to use (defaults to \code{date}).}
}
\value{
Returns data with appended selection weights columns:
\itemize{
\item \code{psel_by} - The minutes column used
\item \code{psel_min} - Probability of selection by time of day (min column)
\item \code{psel_doy} - Probability of selection by day of year
\item \code{psel} - Probability of selection overall
\item \code{psel_scaled} - Probability of selection scaled overall
\item \code{psel_std} - Probability of selection standardized within a site
\item \code{psel_normalized} - Probability of selection normalized within a site
}
}
\description{
Calculate selection weights for a series of recordings based on the selection
parameters defined by \code{sim_selection_weights()}.
}
\examples{
s <- clean_site_index(example_sites_clean,
  name_date_time = c("date_time_start", "date_time_end")
)
m <- clean_metadata(project_files = example_files) |>
  add_sites(s) |>
  calc_sun()

params <- sim_selection_weights()
calc_selection_weights(m, params = params)
}
