% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_patterns.R
\name{create_pattern}
\alias{create_pattern}
\alias{create_pattern_date}
\alias{create_pattern_time}
\alias{create_pattern_dt_sep}
\alias{create_pattern_aru_id}
\alias{create_pattern_site_id}
\alias{create_pattern_tz_offset}
\alias{test_pattern}
\title{Create a pattern to match date}
\usage{
create_pattern_date(
  order = "ymd",
  sep = c("_", "-", ""),
  yr_digits = 4,
  look_ahead = "",
  look_behind = ""
)

create_pattern_time(
  sep = c("_", "-", ":", ""),
  seconds = "yes",
  look_ahead = "",
  look_behind = ""
)

create_pattern_dt_sep(
  sep = "T",
  optional = FALSE,
  look_ahead = "",
  look_behind = ""
)

create_pattern_aru_id(
  arus = c("BARLT", "S\\\\d(A|U)", "SM\\\\d", "SMM", "SMA"),
  n_digits = c(4, 8),
  sep = c("_", "-", ""),
  prefix = "",
  suffix = "",
  look_ahead = "",
  look_behind = ""
)

create_pattern_site_id(
  prefix = c("P", "Q"),
  p_digits = 2,
  sep = c("_", "-"),
  suffix = "",
  s_digits = 1,
  look_ahead = "",
  look_behind = ""
)

create_pattern_tz_offset(
  direction_from_UTC = "West",
  n_digits_hrs = 2,
  n_digits_min = 2
)

test_pattern(test, pattern)
}
\arguments{
\item{order}{Character vector. Expected orders of (y)ear, (m)onth and (d)ate.
Default is "ymd" for Year-Month-Date order. Can have more than one possible
order.}

\item{sep}{Character vector. Expected separator(s) between the pattern parts.
Can be "" for no separator.}

\item{yr_digits}{Numeric vector. Number of digits in Year, either 2 or 4.}

\item{look_ahead}{Pattern to look ahead or after string Can be a regular expression or text.}

\item{look_behind}{Pattern to look before behind string. Can be a regular expression or text.}

\item{seconds}{Character. Whether seconds are included. Options are "yes",
"no", "maybe".}

\item{optional}{Logical. Whether the separator should be optional or not.
Allows matching on different date/time patterns.}

\item{arus}{Character vector. Pattern(s) identifying the ARU prefix (usually
model specific).}

\item{n_digits}{Numeric vector. Number of digits expected to follow the
\code{arus} pattern. Can be one or two (a range).}

\item{prefix}{Character vector. Prefix(es) for site ids.}

\item{suffix}{Character vector. Suffix(es) for site ids.}

\item{p_digits}{Numeric vector. Number(s) of digits following the \code{prefix}.}

\item{s_digits}{Numeric vector. Number(s) of digits following the \code{suffix}.}

\item{direction_from_UTC}{Character. Must be on of "West", "East" or "Both"}

\item{n_digits_hrs}{Numeric vector. Number(s) of digits for hours in offset.}

\item{n_digits_min}{Numeric vector. Number(s) of digits for minutes in offset.}

\item{test}{Character vector. Examples of text to test.}

\item{pattern}{Character. Regular expression pattern to test.}
}
\value{
Either a pattern (\code{create_pattern_xxx()}) or the text extracted by a
pattern (\code{test_pattern()})
}
\description{
Helper functions to create regular expression patterns to match different
metadata in file paths.
}
\details{
By default \code{create_pattern_aru_id()} matches many common ARU patterns like
\code{BARLT0000}, \code{S4A0000}, \code{SM40000}, \code{SMM0000}, \code{SMA0000}.

\code{test_pattern()} is a helper function to see what a regular expression
pattern will pick out of some example text. Can be used to see if your
pattern grabs what you want. This is just a simple wrapper around
\code{stringr::str_extract()}.
}
\section{Functions}{
\itemize{
\item \code{create_pattern_date()}: Create a pattern to match a date

\item \code{create_pattern_time()}: Create a pattern to match a time

\item \code{create_pattern_dt_sep()}: Create a pattern to match a date/time separator

\item \code{create_pattern_aru_id()}: Create a pattern to match an ARU id

\item \code{create_pattern_site_id()}: Create a pattern to match a site id

\item \code{create_pattern_tz_offset()}: Create a pattern to match a site id

\item \code{test_pattern()}: Test patterns

}}
\examples{
create_pattern_date() # Default matches 2020-01-01 or 2020_01_01 or 20200101
# ("-", "_" or "" as separators)
create_pattern_date(sep = "") # Matches only 20200101 (no separator allowed)

create_pattern_time() # Default matches 23_59_59 (_, -, :, as optional separators)
create_pattern_time(sep = "", seconds = "no") # Matches 2359 (no seconds no separators)

create_pattern_dt_sep() # Default matches 'T' as a required separator
create_pattern_dt_sep(optional = TRUE) # 'T' as an optional separator
create_pattern_dt_sep(c("T", "_", "-")) # 'T', '_', or '-' as separators

create_pattern_aru_id()
create_pattern_aru_id(prefix = "CWS")
create_pattern_aru_id(n_digits = 12)


create_pattern_site_id() # Default matches P00-0
create_pattern_site_id(
  prefix = "site", p_digits = 3, sep = "",
  suffix = c("a", "b", "c"), s_digits = 0
) # Matches site000a


create_pattern_site_id() # Default matches P00-0
create_pattern_site_id(
  prefix = "site", p_digits = 3, sep = "",
  suffix = c("a", "b", "c"), s_digits = 0
) # Matches site000a

pat <- create_pattern_aru_id(prefix = "CWS")
test_pattern("CWS_BARLT1012", pat) # No luck
pat <- create_pattern_aru_id(prefix = "CWS_")
test_pattern("CWS_BARLT1012", pat) # Ah ha!
pat <- create_pattern_site_id()

pat <- create_pattern_site_id()
test_pattern("P03", pat) # Nope
test_pattern("P03-1", pat) # Success!

pat <- create_pattern_site_id(prefix = "site", p_digits = 3, sep = "", s_digits = 0)
test_pattern("site111", pat)
pat <- create_pattern_site_id(
  prefix = "site", p_digits = 3, sep = "",
  suffix = c("a", "b", "c"), s_digits = 0
)
test_pattern(c("site9", "site100a"), pat)

}
