% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssir.R
\name{ssir}
\alias{ssir}
\title{Stochastic SIR simulation}
\usage{
ssir(
  N,
  T = 300,
  alpha,
  avg_start = 45,
  min_start = 20,
  inf_period = 4,
  inf_init = 32,
  report = 0.02,
  lag = 7,
  rep = NULL
)
}
\arguments{
\item{N}{Numeric. The total population size.}

\item{T}{Numeric. The duration of the simulation in time steps. Default is 300.}

\item{alpha}{Numeric. The transmission rate. Must be a number between 0 and 1.}

\item{avg_start}{Numeric. The average start day of the epidemic. Default is 45.}

\item{min_start}{Numeric. The minimum start day of the epidemic. Default is 20.}

\item{inf_period}{Numeric. The duration of the infectious period in time steps. Default is 4.}

\item{inf_init}{Numeric. The initial number of infected individuals. Default is 32.}

\item{report}{Numeric. The proportion of cases that are reported. Default is 0.02.}

\item{lag}{Numeric. The average delay in reporting cases. Default is 7.}

\item{rep}{Numeric or NULL. The number of simulation replications to run.
If NULL or 1, a single simulation is run.}
}
\value{
If rep is NULL or 1, returns an object of class "ssir_epidemic" containing:
\item{new_inf}{Vector of new infections at each time step}
\item{reported_cases}{Vector of reported cases at each time step}
\item{S}{Vector of susceptible individuals at each time step}
\item{I}{Vector of infectious individuals at each time step}
\item{R}{Vector of removed individuals at each time step}
\item{parameters}{List of input parameters}

If rep > 1, returns an object of class "ssir_epidemic_multi" containing
multiple simulation results.
}
\description{
This function runs a stochastic Susceptible-Infectious-Removed (SIR) epidemic simulation.
It can run a single simulation or multiple replications.
Also simulates laboratory confirmed cases
}
\examples{
# Run a single simulation
result <- ssir(N = 10000, T = 300, alpha = 0.3, inf_period = 4,
inf_init = 32, report = 0.02, lag = 7)

# Run multiple simulations
multi_result <- ssir(N = 10000, T = 300, alpha = 0.3, inf_period = 4, inf_init = 32,
report = 0.02, lag = 7, rep = 100)

}
