/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.BlockOnParentShardTask;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ITask;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitializeTask;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ProcessTask;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardConsumer;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShutdownNotificationTask;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShutdownReason;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShutdownTask;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.TaskType;

class ConsumerStates {
    static final ConsumerState INITIAL_STATE = ShardConsumerState.WAITING_ON_PARENT_SHARDS.getConsumerState();
    static final ConsumerState SHUTDOWN_REQUEST_COMPLETION_STATE = new ShutdownNotificationCompletionState();

    ConsumerStates() {
    }

    private static ConsumerState shutdownStateFor(ShutdownReason reason) {
        switch (reason) {
            case REQUESTED: {
                return ShardConsumerState.SHUTDOWN_REQUESTED.getConsumerState();
            }
            case TERMINATE: 
            case ZOMBIE: {
                return ShardConsumerState.SHUTTING_DOWN.getConsumerState();
            }
        }
        throw new IllegalArgumentException("Unknown reason: " + (Object)((Object)reason));
    }

    static class ShutdownCompleteState
    implements ConsumerState {
        ShutdownCompleteState() {
        }

        @Override
        public ITask createTask(ShardConsumer consumer) {
            if (consumer.getShutdownNotification() != null) {
                consumer.getShutdownNotification().shutdownComplete();
            }
            return null;
        }

        @Override
        public ConsumerState successTransition() {
            return this;
        }

        @Override
        public ConsumerState shutdownTransition(ShutdownReason shutdownReason) {
            return this;
        }

        @Override
        public TaskType getTaskType() {
            return TaskType.SHUTDOWN_COMPLETE;
        }

        @Override
        public ShardConsumerState getState() {
            return ShardConsumerState.SHUTDOWN_COMPLETE;
        }

        @Override
        public boolean isTerminal() {
            return true;
        }
    }

    static class ShuttingDownState
    implements ConsumerState {
        ShuttingDownState() {
        }

        @Override
        public ITask createTask(ShardConsumer consumer) {
            return new ShutdownTask(consumer.getShardInfo(), consumer.getRecordProcessor(), consumer.getRecordProcessorCheckpointer(), consumer.getShutdownReason(), consumer.getStreamConfig().getStreamProxy(), consumer.getStreamConfig().getInitialPositionInStream(), consumer.isCleanupLeasesOfCompletedShards(), consumer.getLeaseManager(), consumer.getTaskBackoffTimeMillis());
        }

        @Override
        public ConsumerState successTransition() {
            return ShardConsumerState.SHUTDOWN_COMPLETE.getConsumerState();
        }

        @Override
        public ConsumerState shutdownTransition(ShutdownReason shutdownReason) {
            return ShardConsumerState.SHUTDOWN_COMPLETE.getConsumerState();
        }

        @Override
        public TaskType getTaskType() {
            return TaskType.SHUTDOWN;
        }

        @Override
        public ShardConsumerState getState() {
            return ShardConsumerState.SHUTTING_DOWN;
        }

        @Override
        public boolean isTerminal() {
            return false;
        }
    }

    static class ShutdownNotificationCompletionState
    implements ConsumerState {
        ShutdownNotificationCompletionState() {
        }

        @Override
        public ITask createTask(ShardConsumer consumer) {
            return null;
        }

        @Override
        public ConsumerState successTransition() {
            return this;
        }

        @Override
        public ConsumerState shutdownTransition(ShutdownReason shutdownReason) {
            if (shutdownReason != ShutdownReason.REQUESTED) {
                return shutdownReason.getShutdownState();
            }
            return this;
        }

        @Override
        public TaskType getTaskType() {
            return TaskType.SHUTDOWN_NOTIFICATION;
        }

        @Override
        public ShardConsumerState getState() {
            return ShardConsumerState.SHUTDOWN_REQUESTED;
        }

        @Override
        public boolean isTerminal() {
            return false;
        }
    }

    static class ShutdownNotificationState
    implements ConsumerState {
        ShutdownNotificationState() {
        }

        @Override
        public ITask createTask(ShardConsumer consumer) {
            return new ShutdownNotificationTask(consumer.getRecordProcessor(), consumer.getRecordProcessorCheckpointer(), consumer.getShutdownNotification());
        }

        @Override
        public ConsumerState successTransition() {
            return SHUTDOWN_REQUEST_COMPLETION_STATE;
        }

        @Override
        public ConsumerState shutdownTransition(ShutdownReason shutdownReason) {
            if (shutdownReason == ShutdownReason.REQUESTED) {
                return SHUTDOWN_REQUEST_COMPLETION_STATE;
            }
            return shutdownReason.getShutdownState();
        }

        @Override
        public TaskType getTaskType() {
            return TaskType.SHUTDOWN_NOTIFICATION;
        }

        @Override
        public ShardConsumerState getState() {
            return ShardConsumerState.SHUTDOWN_REQUESTED;
        }

        @Override
        public boolean isTerminal() {
            return false;
        }
    }

    static class ProcessingState
    implements ConsumerState {
        ProcessingState() {
        }

        @Override
        public ITask createTask(ShardConsumer consumer) {
            return new ProcessTask(consumer.getShardInfo(), consumer.getStreamConfig(), consumer.getRecordProcessor(), consumer.getRecordProcessorCheckpointer(), consumer.getDataFetcher(), consumer.getTaskBackoffTimeMillis(), consumer.isSkipShardSyncAtWorkerInitializationIfLeasesExist());
        }

        @Override
        public ConsumerState successTransition() {
            return ShardConsumerState.PROCESSING.getConsumerState();
        }

        @Override
        public ConsumerState shutdownTransition(ShutdownReason shutdownReason) {
            return shutdownReason.getShutdownState();
        }

        @Override
        public TaskType getTaskType() {
            return TaskType.PROCESS;
        }

        @Override
        public ShardConsumerState getState() {
            return ShardConsumerState.PROCESSING;
        }

        @Override
        public boolean isTerminal() {
            return false;
        }
    }

    static class InitializingState
    implements ConsumerState {
        InitializingState() {
        }

        @Override
        public ITask createTask(ShardConsumer consumer) {
            return new InitializeTask(consumer.getShardInfo(), consumer.getRecordProcessor(), consumer.getCheckpoint(), consumer.getRecordProcessorCheckpointer(), consumer.getDataFetcher(), consumer.getTaskBackoffTimeMillis(), consumer.getStreamConfig());
        }

        @Override
        public ConsumerState successTransition() {
            return ShardConsumerState.PROCESSING.getConsumerState();
        }

        @Override
        public ConsumerState shutdownTransition(ShutdownReason shutdownReason) {
            return shutdownReason.getShutdownState();
        }

        @Override
        public TaskType getTaskType() {
            return TaskType.INITIALIZE;
        }

        @Override
        public ShardConsumerState getState() {
            return ShardConsumerState.INITIALIZING;
        }

        @Override
        public boolean isTerminal() {
            return false;
        }
    }

    static class BlockedOnParentState
    implements ConsumerState {
        BlockedOnParentState() {
        }

        @Override
        public ITask createTask(ShardConsumer consumer) {
            return new BlockOnParentShardTask(consumer.getShardInfo(), consumer.getLeaseManager(), consumer.getParentShardPollIntervalMillis());
        }

        @Override
        public ConsumerState successTransition() {
            return ShardConsumerState.INITIALIZING.getConsumerState();
        }

        @Override
        public ConsumerState shutdownTransition(ShutdownReason shutdownReason) {
            return ShardConsumerState.SHUTDOWN_COMPLETE.getConsumerState();
        }

        @Override
        public TaskType getTaskType() {
            return TaskType.BLOCK_ON_PARENT_SHARDS;
        }

        @Override
        public ShardConsumerState getState() {
            return ShardConsumerState.WAITING_ON_PARENT_SHARDS;
        }

        @Override
        public boolean isTerminal() {
            return false;
        }
    }

    static interface ConsumerState {
        public ITask createTask(ShardConsumer var1);

        public ConsumerState successTransition();

        public ConsumerState shutdownTransition(ShutdownReason var1);

        public TaskType getTaskType();

        public ShardConsumerState getState();

        public boolean isTerminal();
    }

    static enum ShardConsumerState {
        WAITING_ON_PARENT_SHARDS(new BlockedOnParentState()),
        INITIALIZING(new InitializingState()),
        PROCESSING(new ProcessingState()),
        SHUTDOWN_REQUESTED(new ShutdownNotificationState()),
        SHUTTING_DOWN(new ShuttingDownState()),
        SHUTDOWN_COMPLETE(new ShutdownCompleteState());

        private final ConsumerState consumerState;

        private ShardConsumerState(ConsumerState consumerState) {
            this.consumerState = consumerState;
        }

        public ConsumerState getConsumerState() {
            return this.consumerState;
        }
    }
}

