% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeCues.R
\name{makeCues}
\alias{makeCues}
\title{Creates a string with the cues for each frequency band and segment seperated by "_"}
\usage{
makeCues(WAVE, IntensitySteps = 5, Smooth = 800)
}
\arguments{
\item{WAVE}{A Wave object (see \link{tuneR}). Currently it is implemented for use with 16kHz sampling rate.}

\item{IntensitySteps}{Number of steps that the intensity gets compressed to. Default is 5.}

\item{Smooth}{A parameter for using the kernel smooth function provied by the package zoo.}
}
\value{
A string containing the coding. Each band and part is seperated by "_"
}
\description{
Creates a string with the cues for each frequency band and segment seperated by "_"
}
\examples{
\dontrun{
         
         library(tuneR)
         library(seewave)
         Wave=readWave("MyWaveFile.wav")
         if(Wave@samp.rate!=16000){
         Wave=resamp(Wave,f=Wave@samp.rate,g=16000,output="Wave")
         }
         Cues=makeCues(Wave,IntensitySteps=5,Smooth=800)
         
         }
}
\author{
Denis Arnold
}
