% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_mutate.R
\name{monitor_mutate}
\alias{monitor_mutate}
\title{Apply a function to \emph{mts_monitor} time series}
\usage{
monitor_mutate(monitor = NULL, FUN = NULL, ...)
}
\arguments{
\item{monitor}{\emph{mts_monitor} object.}

\item{FUN}{Function used to modify time series.}

\item{...}{Additional arguments to be passed to \code{FUN}.}
}
\value{
A modified \code{mts_monitor} object. (A list with
\code{meta} and \code{data} dataframes.)
}
\description{
This function works similarly to \code{dplyr::mutate()} and applies
\code{FUN} to each time series found in \code{monitor$data}. \code{FUN} must
be a function that accepts a numeric vector as its first argument and returns
a vector of the same length.
}
\examples{
library(AirMonitor)

Carmel_Valley \%>\%
  monitor_filterDatetime(2016080207, 2016080212) \%>\%
  monitor_toCSV(includeMeta = FALSE) \%>\%
  cat()

Carmel_Valley \%>\%
  monitor_filterDatetime(2016080207, 2016080212) \%>\%
  monitor_mutate(function(x) { return(x / 2) }) \%>\%
  monitor_toCSV(includeMeta = FALSE) \%>\%
  cat()

}
