% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/founderPop.R
\name{sampleHaplo}
\alias{sampleHaplo}
\title{Sample haplotypes from a MapPop}
\usage{
sampleHaplo(mapPop, nInd, inbred = FALSE, replace = TRUE)
}
\arguments{
\item{mapPop}{the \code{\link{MapPop-class}} used to 
sample haplotypes}

\item{nInd}{the number of individuals to create}

\item{inbred}{should new individuals be fully inbred}

\item{replace}{should haplotypes be sampled with replacement}
}
\value{
an object of \code{\link{MapPop-class}}
}
\description{
Creates a new \code{\link{MapPop-class}} from an existing 
\code{\link{MapPop-class}} by randomly sampling haplotypes.
}
\examples{
# Create genetic map for a single chromosome with 1 Morgan
# Chromosome contains 11 equally spaced segregating sites
genMap = list(seq(0,1,length.out=11))
founderPop = trackHaploPop(genMap=genMap,nInd=2,inbred=TRUE)
founderPop = sampleHaplo(nInd=20,mapPop=founderPop)

}
