% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterObject.R
\name{calculateMarginalLogLikelihood}
\alias{calculateMarginalLogLikelihood}
\title{Calculates the marginal log-likelihood for a set of parameters}
\usage{
calculateMarginalLogLikelihood(
  parameter,
  mcmc,
  mixture,
  n.samples,
  divisor,
  warnings = TRUE
)
}
\arguments{
\item{parameter}{An object created with \code{initializeParameterObject}.}

\item{mcmc}{An object created with \code{initializeMCMCObject}}

\item{mixture}{determines for which mixture the marginal log-likelihood should be calculated}

\item{n.samples}{How many samples should be used for the calculation}

\item{divisor}{A value > 1 in order to scale down the tails of the importance distribution}

\item{warnings}{Print warnings such as when the variance of a parameter is 0, which might occur when parameter is fixed}
}
\value{
This function returns the model object created.
}
\description{
initializes the model object.
}
\details{
calculateMarginalLogLikelihood Calculate marginal log-likelihood for
calculation of the Bayes factor using a generalized harmonix mean estimator of the 
marginal likelihood. See Gronau et al. (2017) for details
}
\examples{
\dontrun{
# Calculate the log-marginal likelihood
parameter <- loadParameterObject("parameter.Rda")
mcmc <- loadMCMCObject("mcmc.Rda")
calculate_marginal_likelihood(parameter, mcmc, mixture = 1, 
samples = 500, scaling = 1.5)

# Calculate the Bayes factor for two models
parameter1 <- loadParameterObject("parameter1.Rda")
parameter2 <- loadParameterObject("parameter2.Rda")
mcmc1 <- loadMCMCObject("mcmc1.Rda")
mcmc2 <- loadMCMCObject("mcmc2.Rda")
mll1 <- calculate_marginal_likelihood(parameter1, mcmc1, mixture = 1, 
samples = 500, scaling = 1.5)
mll2 <- calculate_marginal_likelihood(parameter2, mcmc2, mixture = 1, 
samples = 500, scaling = 1.5)
cat("Bayes factor: ", mll1 - mll2, "\n")
}
 
}
