% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmcObject.R
\name{initializeMCMCObject}
\alias{initializeMCMCObject}
\title{Initialize MCMC}
\usage{
initializeMCMCObject(
  samples,
  thinning = 1,
  adaptive.width = 100,
  est.expression = TRUE,
  est.csp = TRUE,
  est.hyper = TRUE,
  est.mix = TRUE
)
}
\arguments{
\item{samples}{Number of samples to be produced when running the 
MCMC algorithm. No default value.}

\item{thinning}{The thinning interval between consecutive observations. If set to 
1, every step will be saved as a sample. Default value is 1.}

\item{adaptive.width}{Number that determines how often the acceptance/rejection
window should be altered. Default value is 100 samples.
Proportion of MCMC steps where the proposal distribution is adaptive can be set using \code{mcmc$setStepsToAdapt}. The default parameter passed in as -1 uses the full iterations.}

\item{est.expression}{Boolean that tells whether or not synthesis rate values
should be estimated in the MCMC algorithm run. Default value is TRUE.}

\item{est.csp}{Boolean that tells whether or not codon specific values
should be estimated in the MCMC algorithm run. Default value is TRUE.}

\item{est.hyper}{Boolean that tells whether or not hyper parameters
should be estimated in the MCMC algorithm run. Default value is TRUE.
Setting for expression noise parameter sepsilon can be overridden by setting \code{fix.observation.noise} in \code{initializeModelObject()}}

\item{est.mix}{Boolean that tells whether or not the genes' mixture element
should be estimated in the MCMC algorithm run. Default value is TRUE.}
}
\value{
mcmc Returns an intialized MCMC object.
}
\description{
\code{initializeMCMCObject} initializes a MCMC object to 
perform a model fitting for a parameter and model object.
}
\details{
\code{initializeMCMCObject} sets up the MCMC object 
(monte carlo markov chain) and returns the object so a model fitting can be done.
It is important to note that est.expression and est.hyper will affect one another
negatively if their values differ.
}
\examples{

## initializing an object of type mcmc

samples <- 2500
thinning <- 50
adaptiveWidth <- 25

## estimate all parameter types
mcmc <- initializeMCMCObject(samples = samples, thinning = thinning, adaptive.width=adaptiveWidth, 
                             est.expression=TRUE, est.csp=TRUE, est.hyper=TRUE, est.mix = TRUE) 
                             
## do not estimate expression values, initial conditions will remain constant
mcmc <- initializeMCMCObject(samples = samples, thinning = thinning, adaptive.width=adaptiveWidth, 
                             est.expression=FALSE, est.csp=TRUE, est.hyper=TRUE, est.mix = TRUE) 
                             
## do not estimate hyper parameters, initial conditions will remain constant
mcmc <- initializeMCMCObject(samples = samples, thinning = thinning, adaptive.width=adaptiveWidth, 
                             est.expression=TRUE, est.csp=TRUE, est.hyper=FALSE, est.mix = TRUE) 

}
