% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posthoc_planner.R
\name{Posthoc_planner}
\alias{Posthoc_planner}
\title{Post Hoc Planner for FWER and Test Recommendation v1.6}
\usage{
Posthoc_planner(
  model,
  compare = NULL,
  alpha = 0.05,
  scope = c("factor", "cells"),
  equal_var = TRUE,
  unequal_n = FALSE,
  independence = TRUE,
  liberal_ok = FALSE,
  orientation = c("rows", "cols"),
  digits = 4,
  percent_digits = 1,
  observed_cells = TRUE
)
}
\arguments{
\item{model}{aov or lm object (complete model). Data are reconstructed with model.frame().}

\item{compare}{Character with the name(s) of the factor(s) to compare:
- One name: main effect.
- Several names: if scope="cells" compares A:B:... cells; if scope="factor", reports each factor.
If omitted, uses all factors when scope="factor", or the first factor when scope="cells".}

\item{alpha}{Overall significance level (FWER target), default 0.05.}

\item{scope}{"factor" compares each factor separately; "cells" compares interaction cells.}

\item{equal_var}{Logical; assume homoscedasticity (default TRUE).}

\item{unequal_n}{Logical; expect moderate imbalance of group sizes (default FALSE).}

\item{independence}{Logical; if TRUE reports FWER "under independence" (default TRUE).}

\item{liberal_ok}{Logical; allows more liberal suggestions (LSD/Duncan/SNK) (default FALSE).}

\item{orientation}{"rows" (metrics as rows, default) or "cols".}

\item{digits}{Decimal places for numeric output, default 4.}

\item{percent_digits}{Decimal places for percentages, default 1.}

\item{observed_cells}{Logical; in scope="cells", count only observed cells (drop NA). Default TRUE.}
}
\value{
data.frame.
  - orientation="rows": first column "Metric", rest columns are units (factor/cells).
  - orientation="cols": one row per unit, metrics as columns.
  Includes: g levels, m comparisons, global alpha, Bonferroni/Sidak alphas,
  FWERs (under independence), "Suggested p-value adjustment" and "Post hoc suggestion".
}
\description{
One-shot planner for factor or cell comparisons, reporting m, FWER,
suggested adjustments (Bonferroni/Sidak) and a post hoc recommendation
(Holm, Tukey, Duncan, Gabriel, Scheffe, SNK, etc.) before testing.
}
\examples{
# example code


}
