% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CorphenoMaker.R
\name{refAdd}
\alias{refAdd}
\title{Add individuals to the CorPheno file.}
\usage{
refAdd(phenoId, phenoValues, ignoreDupes = F, phenoFile, writeCor = T)
}
\arguments{
\item{phenoId}{Path to file containing list of invididuals to be added to CorPheno with the three columns 'UNIQID','Fam','Pheno_Pop'.
A full example called 'Example.phenoId' is present in the 'extdata' folder of the AncestryMapper package.}

\item{phenoValues}{Path to file containing information on each population to be added, such as continental origin and colours as well as other information.
A full example called 'Example.phenoValues' is present in the 'extdata' folder of the AncestryMapper package.}

\item{ignoreDupes}{Logical value (TRUE or FALSE), specifying if the presence of individual IDs already in CorPheno should be ignored. Useful if the user knows this is the case and just wants the individuals not already included in the directed phenoFile.
Default = FALSE}

\item{phenoFile}{Main file with phenotype information for each individual. A sample file called CorPheno is included with the package in the ext folder. It contains values for the samples from the HGDP. This function augments this file with any novel individuals.
If no value is given the sample file in the ext folder is used by default.}

\item{writeCor}{Logical value (TRUE or FALSE), specifying if the new CorPheno should overwrite the file the given in 'phenoFile'. A backup of the previous CorPheno file with the same path as given in 'phenoFile' with '_Original' appended to the name will also be produced. You could alternatively write out your new file to your preferred location with write.table, making sure to keep the columns tab spaced. Default = TRUE}
}
\description{
Add individuals to the CorPheno file in order to order and plot them with specific colours. Ids that aren't in the CorPheno will be plotted under 'Unspecified' and given a grey colour by plotAMids()
}
\examples{
\dontrun{
phenoIdPth <- system.file ("extdata", "Example.phenoId", package = "AncestryMapper")
PhenoValPth <- system.file("extdata", "Example.phenoValues", package = "AncestryMapper")
Corpheno <- system.file("extdata", "CorPheno", package = "AncestryMapper")

refAdd(phenoId = phenoIdPth, phenoValues = PhenoValPth, phenoFile = Corpheno)

}
}

