% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sensitivity.R
\name{estimate_range}
\alias{estimate_range}
\title{Estimate ranges from two or more calibrations}
\usage{
estimate_range(
  mcmc,
  position,
  app = "bcal",
  estimates = c("mean", "q1", "median", "q3", "ci.inf", "ci.sup"),
  quiet = "partial",
  bin_width = 1,
  decimal = ".",
  separator = ","
)
}
\arguments{
\item{mcmc}{A vector of path names to the MCMC files.}

\item{position}{Numeric vector containing the positions of the columns
corresponding to the MCMC chains of interest, or a vector of column
names.}

\item{app}{Name of the application that created the MCMC files,
one of \code{bcal}, \code{oxcal}, \code{chronomodel.}}

\item{estimates}{Numeric vector containing the positions of the columns
corresponding to the statistics of interest returned by the
\code{multi_marginal_statistics()} function, or a vector of column
names.}

\item{quiet}{One of \code{no} (default) to allow messages and warnings,
\code{partial} to suppress messages and allow warnings,
or \code{yes} to suppress messages and warnings.}

\item{bin_width}{If \code{app} is set to \code{bcal}, the bin width
specified for the \href{https://bcal.shef.ac.uk/}{BCal} calibration.
Defaults to the \href{https://bcal.shef.ac.uk/}{BCal} default of 1.}

\item{decimal}{If \code{app} is set to \code{chronomodel},
either \code{.} (default) or \code{,}, the two choices offered by
\href{https://chronomodel.com/}{ChronoModel}.}

\item{separator}{If \code{app} is set to \code{chronomodel}, the character
used to separate fields in the CSV file.  Defaults to \code{,}.}
}
\value{
A list with the following components:
\describe{
\item{range_table}{A matrix of estimate ranges.}
\item{mean}{The mean of the ranges in \code{range_table}.}
\item{sd}{The standard deviation of the ranges in \code{range_table}.}
\item{min}{The minimum of the ranges in \code{range_table}.}
\item{median}{The median of the ranges in \code{range_table}.}
\item{max}{The maximum value of the ranges in \code{range_table}.}
}
}
\description{
Calculates the ranges of summary statistics from the output of two or more
runs of the MCMC algorithm. Results are given in
calendar years for statistics that estimate them.
}
\details{
This function is useful for estimating the sensitivity of calibration results
to different model parameters.
}
\examples{
\dontrun{
## Generate 0's
res <- estimate_range(mcmc = c("http://tsdye.online/AP/ox.csv",
"http://tsdye.online/AP/ox.csv"), position = c(1, 2),
app = "oxcal", quiet = "yes")
sum(res$range_table)
}

}
\author{
Thomas S. Dye, \email{tsd@tsdye.online}
}
