% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot.R
\docType{methods}
\name{plot_events}
\alias{plot_events}
\alias{plot,MCMC,missing-method}
\title{Plot Events}
\usage{
\S4method{plot}{MCMC,missing}(
  x,
  calendar = getOption("ArchaeoPhases.calendar"),
  density = TRUE,
  interval = NULL,
  level = 0.95,
  sort = TRUE,
  decreasing = TRUE,
  main = NULL,
  sub = NULL,
  ann = graphics::par("ann"),
  axes = TRUE,
  frame.plot = FALSE,
  panel.first = NULL,
  panel.last = NULL,
  col.density = "grey",
  col.interval = "#77AADD",
  ...
)
}
\arguments{
\item{x}{An \code{\linkS4class{MCMC}} object.}

\item{calendar}{A \code{\linkS4class{TimeScale}} object specifying the target calendar
(see \code{\link[=calendar]{calendar()}}).}

\item{density}{A \code{\link{logical}} scalar: should estimated density be plotted?}

\item{interval}{A \code{\link{character}} string specifying the confidence interval to
be drawn. It must be one of "\code{credible}" (credible interval) or "\code{hdr}"
(highest posterior density interval). Any unambiguous substring can be
given. If \code{NULL} (the default) no interval is computed.}

\item{level}{A length-one \code{\link{numeric}} vector giving the confidence level.}

\item{sort}{A \code{\link{logical}} scalar: should the data be sorted?}

\item{decreasing}{A \code{\link{logical}} scalar: should the sort order be decreasing?
Only used if \code{sort} is \code{TRUE}.}

\item{main}{A \code{\link{character}} string giving a main title for the plot.}

\item{sub}{A \code{\link{character}} string giving a subtitle for the plot.}

\item{ann}{A \code{\link{logical}} scalar: should the default annotation (title and x
and y axis labels) appear on the plot?}

\item{axes}{A \code{\link{logical}} scalar: should axes be drawn on the plot?}

\item{frame.plot}{A \code{\link{logical}} scalar: should a box be drawn around the
plot?}

\item{panel.first}{An an \code{expression} to be evaluated after the plot axes are
set up but before any plotting takes place. This can be useful for drawing
background grids.}

\item{panel.last}{An \code{expression} to be evaluated after plotting has taken
place but before the axes, title and box are added.}

\item{col.density, col.interval}{A specification for the plotting colors.}

\item{...}{Extra parameters to be passed to \code{\link[stats:density]{stats::density()}}.}
}
\value{
\code{plot()} is called it for its side-effects: it results in a graphic being
displayed (invisibly returns \code{x}).
}
\description{
Plots credible intervals or HPD regions of a series of events.
}
\examples{
## Coerce to MCMC
eve <- as_events(mcmc_events, calendar = CE(), iteration = 1)

## Summary
summary(eve, calendar = CE())
summary(eve, calendar = BP())

## Plot events
plot(eve, calendar = CE(), interval = "credible", level = 0.68)
plot(eve, calendar = BP(), interval = "hdr", level = 0.68)
plot(eve[, 1], interval = "hdr")

## Compute phases
pha <- phases(eve, groups = list(B = c(2, 4), A = c(1, 3)))

## Summary
summary(pha, calendar = CE())
summary(pha, calendar = BP())

## Plot phases
plot(pha, calendar = BP())
plot(pha, succession = "hiatus")
plot(pha, succession = "transition")
}
\seealso{
\code{\link[stats:density]{stats::density()}}

Other plot methods: 
\code{\link{plot_phases}}
}
\author{
A. Philippe, M.-A. Vibet, T. S. Dye, N. Frerebeau
}
\concept{plot methods}
