% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AsyK.R
\name{plot.RIG}
\alias{plot.RIG}
\title{Density Plot by Resiprocal Inverse Gaussian kernel}
\usage{
\method{plot}{RIG}(x, ...)
}
\arguments{
\item{x}{an object of class "RIG"}

\item{\dots}{Not presently used in this implementation}
}
\value{
nothing
}
\description{
Plot density by using Resiprocal Inverse Gaussian Kernel.
}
\examples{
y <- rexp(100, 1)
h <- 0.79 * IQR(y) * length(y) ^ (-1/5)
den<-RIG(y,200,h)
plot(den, type = "s", ylab = "Density Function", lty = 1, xlab = "Time")
d1 <- density(y, bw=h) #To add true density along with estimated
lines(d1,type="p",col="red")
legend("topright", c("Real Density", "Density by RIG Kernel"), col=c("red", "black"), lty=c(1,2))
}
\references{
Scaillet, O. 2004. Density estimation using inverse and reciprocal inverse Gaussian kernels. 	 \emph{Nonparametric Statistics}, \strong{16}, 217-226.
}
\seealso{
To examine RIG estimated values for density see \code{\link{RIG}} and for Mean Squared Error \code{\link{mseRIG}}. Similarly, for plot of Laplace kernel \code{\link{plot.Laplace}}.
}
\author{
Javaria Ahmad Khan, Atif Akbar.
}
