% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/runmodel.R
\name{create_model_objects}
\alias{create_model_objects}
\title{Hierarchical Regression Model Generation}
\usage{
create_model_objects(formulas, dataset, type = "gaussian")
}
\arguments{
\item{formulas}{A set of \code{lm} formulas, created with
create_formula_objects}

\item{dataset}{A data frame containing variables refered to in
\code{formulas}, passed to data argument of \code{lm}}

\item{type}{Family argument to pass to \code{glm}.  Specify "binomial" for
binary logistic regression models.}
}
\value{
A list of \code{lm} model objects
}
\description{
Hierarchical Regression Model Generation
}
\examples{
create_model_objects(create_formula_objects("y", c("lag.quarterly.revenue")
, c("price.index")), dataset = freeny)
freeny_model_formulas <- create_formula_objects("y", c("lag.quarterly.revenue")
, c("price.index"))
create_model_objects(freeny_model_formulas, dataset = freeny)
}

