% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_acr_methods.R
\name{delete_acr}
\alias{delete_acr}
\title{Delete an Azure Container Registry (ACR)}
\description{
Method for the \link[AzureRMR:az_resource_group]{AzureRMR::az_resource_group} class.
}
\section{Usage}{
\preformatted{delete_acr(name, confirm=TRUE, wait=FALSE)
}
}

\section{Arguments}{

\itemize{
\item \code{name}: The name of the container registry.
\item \code{confirm}: Whether to ask for confirmation before deleting.
\item \code{wait}: Whether to wait until the deletion is complete.
}
}

\section{Value}{

NULL on successful deletion.
}

\examples{
\dontrun{

rg <- AzureRMR::get_azure_login()$
    get_subscription("subscription_id")$
    get_resource_group("rgname")

rg$delete_acr("myregistry")

}
}
\seealso{
\link{create_acr}, \link{get_acr}

\link{az_container_registry}

\link{docker_registry} for the registry endpoint

\href{https://docs.microsoft.com/en-us/azure/container-registry/}{ACR documentation} and
\href{https://docs.microsoft.com/en-us/rest/api/containerregistry/registries}{API reference}

\href{https://docs.docker.com/registry/spec/api/}{Docker registry API}
}
