% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_login.R
\name{create_graph_login}
\alias{create_graph_login}
\alias{get_graph_login}
\alias{delete_graph_login}
\alias{list_graph_logins}
\title{Login to Azure Active Directory Graph}
\usage{
create_graph_login(tenant = "common", app = NULL, password = NULL,
  username = NULL, certificate = NULL, auth_type = NULL, version = 2,
  host = "https://graph.microsoft.com/",
  aad_host = "https://login.microsoftonline.com/", scopes = ".default",
  config_file = NULL, token = NULL, ...)

get_graph_login(tenant = "common", selection = NULL, app = NULL,
  scopes = NULL, auth_type = NULL, refresh = TRUE)

delete_graph_login(tenant = "common", confirm = TRUE)

list_graph_logins()
}
\arguments{
\item{tenant}{The Azure Active Directory tenant for which to obtain a login client. Can be a name ("myaadtenant"), a fully qualified domain name ("myaadtenant.onmicrosoft.com" or "mycompanyname.com"), or a GUID. The default is to login via the "common" tenant, which will infer your actual tenant from your credentials.}

\item{app}{The client/app ID to use to authenticate with Azure Active Directory. The default is to login interactively using the Azure CLI cross-platform app, but you can supply your own app credentials as well.}

\item{password}{If \code{auth_type == "client_credentials"}, the app secret; if \code{auth_type == "resource_owner"}, your account password.}

\item{username}{If \code{auth_type == "resource_owner"}, your username.}

\item{certificate}{If `auth_type == "client_credentials", a certificate to authenticate with. This is a more secure alternative to using an app secret.}

\item{auth_type}{The OAuth authentication method to use, one of "client_credentials", "authorization_code", "device_code" or "resource_owner". If \code{NULL}, this is chosen based on the presence of the \code{username} and \code{password} arguments.}

\item{version}{The Azure Active Directory version to use for authenticating.}

\item{host}{Your Microsoft Graph host. Defaults to \verb{https://graph.microsoft.com/}. Change this if you are using a government or private cloud.}

\item{aad_host}{Azure Active Directory host for authentication. Defaults to \verb{https://login.microsoftonline.com/}. Change this if you are using a government or private cloud.}

\item{scopes}{The Microsoft Graph scopes (permissions) to obtain for this Graph login. For \code{create_graph_login}, this is used only for \code{version=2}. For \code{get_graph_login}, set this to NA to require an AAD v1.0 token.}

\item{config_file}{Optionally, a JSON file containing any of the arguments listed above. Arguments supplied in this file take priority over those supplied on the command line. You can also use the output from the Azure CLI \verb{az ad sp create-for-rbac} command.}

\item{token}{Optionally, an OAuth 2.0 token, of class \link[AzureAuth:AzureToken]{AzureAuth::AzureToken}. This allows you to reuse the authentication details for an existing session. If supplied, all other arguments to \code{create_graph_login} will be ignored.}

\item{...}{Other arguments passed to \code{ms_graph$new()}.}

\item{selection}{For \code{get_graph_login}, if you have multiple logins for a given tenant, which one to use. This can be a number, or the input MD5 hash of the token used for the login. If not supplied, \code{get_graph_login} will print a menu and ask you to choose a login.}

\item{refresh}{For \code{get_graph_login}, whether to refresh the authentication token on loading the client.}

\item{confirm}{For \code{delete_graph_login}, whether to ask for confirmation before deleting.}
}
\value{
For \code{get_graph_login} and \code{create_graph_login}, an object of class \code{ms_graph}, representing the login client. For \code{list_graph_logins}, a (possibly nested) list of such objects.

If the AzureR data directory for saving credentials does not exist, \code{get_graph_login} will throw an error.
}
\description{
Login to Azure Active Directory Graph
}
\details{
\code{create_graph_login} creates a login client to authenticate with Microsoft Graph, using the supplied arguments. The authentication token is obtained using \link{get_azure_token}, which automatically caches and reuses tokens for subsequent sessions.

For interactive use, you would normally \emph{not} supply the \code{username} and \code{password} arguments. Omitting them will prompt \code{create_graph_login} to authenticate you with AAD using your browser, which is the recommended method. If you don't have a browser available to your R session, for example if you're using RStudio Server or Azure Databricks, you can specify \verb{auth_type="device_code}".

For non-interactive use, for example if you're calling AzureGraph in a deployment pipeline, the recommended authentication method is via client credentials. For this method, you supply \emph{only} the \code{password} argument, which should contain the client secret for your app registration. You must also specify your own app registration ID, in the \code{app} argument.

The AzureAuth package has a \href{https://cran.r-project.org/package=AzureAuth/vignettes/scenarios.html}{vignette} that goes into more detail on these authentication scenarios.

\code{get_graph_login} returns a previously created login client. If there are multiple existing clients, you can specify which client to return via the \code{selection}, \code{app}, \code{scopes} and \code{auth_type} arguments. If you don't specify which one to return, it will pop up a menu and ask you to choose one.

One difference between \code{create_graph_login} and \code{get_graph_login} is the former will delete any previously saved credentials that match the arguments it was given. You can use this to force AzureGraph to remove obsolete tokens that may be lying around.
}
\examples{
\dontrun{

# without any arguments, this will create a client using your AAD organisational account
az <- create_graph_login()

# retrieve the login in subsequent sessions
az <- get_graph_login()

# this will create an Microsoft Graph client for the tenant 'mytenant.onmicrosoft.com',
# using the client_credentials method
az <- create_graph_login("mytenant", app="{app_id}", password="{password}")

# you can also login using credentials in a json file
az <- create_graph_login(config_file="~/creds.json")

# creating and obtaining a login with specific scopes
create_graph_login("mytenant", scopes=c("User.Read", "Files.ReadWrite.All"))
get_graph_login("mytenant", scopes=c("User.Read", "Files.ReadWrite.All"))

# to use your personal account, set the tenant to one of the following
create_graph_login("9188040d-6c67-4c5b-b112-36a304b66dad")
create_graph_login("consumers")  # requires AzureAuth 1.3.0

}
}
\seealso{
\link{ms_graph}, \link[AzureAuth:get_azure_token]{AzureAuth::get_azure_token} for more details on authentication methods

\href{https://cran.r-project.org/package=AzureAuth/vignettes/scenarios.html}{AzureAuth vignette on authentication scenarios}

\href{https://docs.microsoft.com/en-us/graph/overview}{Microsoft Graph overview},
\href{https://docs.microsoft.com/en-us/graph/api/overview?view=graph-rest-1.0}{REST API reference}
}
