% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blob_version.R
\name{list_blob_versions}
\alias{list_blob_versions}
\alias{delete_blob_version}
\title{List and delete blob versions}
\usage{
list_blob_versions(container, blob)

delete_blob_version(container, blob, version, confirm = TRUE)
}
\arguments{
\item{container}{A blob container.}

\item{blob}{The path/name of a blob.}

\item{version}{For \code{delete_blob_version}, the specific version to delete. This should be a datetime string, in the format \code{yyyy-mm-ddTHH:MM:SS.SSSSSSSZ}.}

\item{confirm}{Whether to ask for confirmation on deleting a blob version.}
}
\value{
For \code{list_blob_versions}, a vector of datetime strings which are the IDs of each version.
}
\description{
List and delete blob versions
}
\details{
A version captures the state of a blob at a given point in time. Each version is identified with a version ID. When blob versioning is enabled for a storage account, Azure Storage automatically creates a new version with a unique ID when a blob is first created and each time that the blob is subsequently modified.

A version ID can identify the current version or a previous version. A blob can have only one current version at a time.

When you create a new blob, a single version exists, and that version is the current version. When you modify an existing blob, the current version becomes a previous version. A new version is created to capture the updated state, and that new version is the current version. When you delete a blob, the current version of the blob becomes a previous version, and there is no longer a current version. Any previous versions of the blob persist.

Versions are different to \link[=list_blob_snapshots]{snapshots}:
\itemize{
\item A new snapshot has to be explicitly created via \code{create_blob_snapshot}. A new blob version is automatically created whenever the base blob is modified (and hence there is no \code{create_blob_version} function).
\item Deleting the base blob will also delete all snapshots for that blob, while blob versions will be retained (but will typically be inaccessible).
\item Snapshots are only available for storage accounts with hierarchical namespaces disabled, while versioning can be used with any storage account.
}
}
