% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaler_config.R
\name{autoscaler_config}
\alias{autoscaler_config}
\alias{autoscaler_profile}
\title{Autoscaler configuration}
\usage{
autoscaler_config(profiles = list(autoscaler_profile()), ...)

autoscaler_profile(name = "Profile", minsize = 1, maxsize = NA,
  default = NA, scale_out = 0.75, scale_in = 0.25, interval = "PT1M",
  window = "PT5M")
}
\arguments{
\item{profiles}{A list of autoscaling profiles, each obtained via a call to \code{autoscaler_profile}.}

\item{...}{Other named arguments that will be treated as resource properties.}

\item{name}{For \code{autoscaler_profile}, a name for the profile.}

\item{minsize, maxsize, default}{For \code{autoscaler_profile}, the minimum, maximum and default number of instances.}

\item{scale_out, scale_in}{For \code{autoscaler_profile}, the CPU usage (a fraction between 0 and 1) at which to scale out and in, respectively.}

\item{interval}{For \code{autoscaler_profile}, The interval between samples, in ISO 8601 format. The default is 1 minute.}

\item{window}{For \code{autoscaler_profile}, the window width over which to compute the percentage CPU. The default is 5 minutes.}
}
\description{
Autoscaler configuration
}
\examples{
autoscaler_config()
autoscaler_config(list(
    autoscaler_profile(minsize=2, maxsize=50, scale_out=0.9, scale_in=0.1)
))
}
\seealso{
\link{create_vm_scaleset}, \link{vmss_config}
}
