% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayeslabel.R
\name{myKLdivergenece}
\alias{myKLdivergenece}
\title{{myKLdivergenece}}
\usage{
myKLdivergenece(nulldens, dens, integral = c(-6, 6), precision = 0.001,
  method = c("MixNorm", "biGaussianMean0"))
}
\arguments{
\item{nulldens}{A list, mu: mean location for each of normal density; sd: sd value for each of normal density; proportion: proportion for each normal density.}

\item{dens}{A list, mu: mean location for each of normal density; sd: sd value for each of normal density; proportion: proportion for each normal density.}

\item{integral}{A two element vector, the first element is integration lower bound; the second element is integration upper bound.}

\item{precision}{A number. The numerical precision for integration calculating. Default=0.001}

\item{method}{The way proposal density is calculated from wether it is "MixNorm" or "biGaussianMean0".}
}
\value{
A number, KL distance between nulldens and dens
}
\description{
Compute Kullback Leibler divergence between biologic null distribution vs. proposed null distribution
}
\keyword{internal}
