% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betapriors.R
\name{IC.prior}
\alias{IC.prior}
\alias{aic.prior}
\alias{AIC.prior}
\alias{bic.prior}
\alias{BIC.prior}
\title{Information Criterion Families of Prior Distribution for Coefficients in BMA
Models}
\usage{
IC.prior(penalty)
}
\arguments{
\item{penalty}{a scalar used in the penalized loglikelihood of the form
penalty*dimension}
}
\value{
returns an object of class "prior", with the family and
hyerparameters.
}
\description{
Creates an object representing the prior distribution on coefficients for
BAS.
}
\details{
The log marginal likelihood is approximated as -2*(deviance +
penalty*dimension).  Allows alternatives to AIC (penalty = 2) and BIC
(penalty = log(n)).  For BIC, the argument may be missing, in which case the
sample size is determined from the call to `bas.glm` and used to dertermine
the penalty.
}
\examples{
IC.prior(2)
          aic.prior()
          bic.prior(100)

}
\seealso{
\code{\link{g.prior}}

Other beta priors: \code{\link{CCH}},
  \code{\link{EB.local}}, \code{\link{Jeffreys}},
  \code{\link{TG}}, \code{\link{beta.prime}},
  \code{\link{g.prior}}, \code{\link{hyper.g.n}},
  \code{\link{hyper.g}}, \code{\link{intrinsic}},
  \code{\link{robust}}, \code{\link{tCCH}},
  \code{\link{testBF.prior}}
}
\author{
Merlise Clyde
}
