% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_matrix.R
\name{which.matrix}
\alias{which.matrix}
\title{Coerce a BAS list object of models into a matrix.}
\usage{
which.matrix(which, n.vars)
}
\arguments{
\item{which}{a 'bas' model object  \code{x$which}}

\item{n.vars}{the total number of predictors, \code{x$n.vars}}
}
\value{
a matrix representation of \code{x$which}, with number of rows equal
to the length of which.models or total number of models and number of
columns \code{x$n.vars}
}
\description{
This function coerces the list object of models to a matrix and fill in the
zeros to facilitate other computations.
}
\details{
\code{which.matrix}  coerces
\code{x$which} into a matrix.
}
\examples{

data(Hald)
Hald.bic <-  bas.lm(Y ~ ., data=Hald, prior="BIC", initprobs="eplogp")
# matrix of model indicators
models <- which.matrix(Hald.bic$which, Hald.bic$n.vars)

}
\seealso{
\code{\link{bas}}

Other as.matrix methods: 
\code{\link{list2matrix.bas}()},
\code{\link{list2matrix.which}()}
}
\author{
Merlise Clyde \email{clyde@duke.edu}
}
\concept{as.matrix methods}
\keyword{regression}
