\name{LBRecap}
\alias{LBRecap}
%- Also NEED an '\alias' for EACH other topic documented here.

\title{Unconditional (complete) likelihood inference for capture-recapture analysis with emphasis on behavioural effect modelling}
\description{
Unconditional (complete) likelihood inference for a large class of discrete-time capture-recapture models under closed population with special emphasis on behavioural effect modelling including also the \emph{meaningful behavioral covariate} approach proposed in Alunni Fegatelli (2013) [PhD thesis]. Many of the standard classical models such as \eqn{M_0}, \eqn{M_b}, \eqn{M_{c_1}}, \eqn{M_t} or \eqn{M_{bt}} can be regarded as particular instances of the aforementioned approach. Other flexible alternatives can be fitted through a careful choice of a meaningful behavioural covariate and a possible partition of its admissible range
}

\usage{
LBRecap ( data,last.column.count = FALSE, neval = 1000, startadd=0, by.incr = 1, 
   mbc.function = c("standard","markov","counts","integer","counts.integer"), 
   mod = c("linear.logistic", "M0", "Mb", "Mc", "Mcb", "Mt", "Msubjective.cut", 
   "Msubjective"), heterogeneity=FALSE, markov.ord=NULL, z.cut=c(), 
   meaningful.mat.subjective = NULL, meaningful.mat.new.value.subjective = NULL, 
   td.cov = NULL, td.cov.formula ="", verbose = FALSE, graph = FALSE, 
   output = c( "base", "complete" ) )
    }
%- maybe also 'usage' for other objects documented here.
\arguments{


\item{data}{can be one of the following: \enumerate{
      \item an \eqn{M} by \eqn{t} binary matrix/data.frame. In this case the input is interpreted as a matrix whose rows contain individual capture histories for all \eqn{M} observed units
      \item a matrix/data.frame with \eqn{(t+1)} columns. The first \eqn{t} columns contain binary entries corresponding to capture occurrences, while the last column contains non negative integers corresponding to frequencies. This format is allowed only when \code{last.column.count} is set to \code{TRUE}
      \item a \eqn{t}-dimensional array or table representing the counts of the \eqn{2^t} contingency table of binary outcomes
}
\eqn{M} is the number of units captured at least once and \eqn{t} is the number of capture occasions.}
\item{last.column.count}{a logical. In the default case \code{last.column.count=FALSE} each row of the input argument \code{data} represents the complete capture history for each observed unit. When \code{last.column.count} is set to \code{TRUE} in each row the first \eqn{t} entries represent one of the observed complete capture histories and the last entry in the last column is the number of observed units with that capture history}
\item{neval}{a positive integer. \code{neval} is the number of values of the population size \eqn{N} where the posterior is evaluated starting from \eqn{M}. The default value is \code{neval}=1000.}
  \item{startadd}{a positive integer. The likelihood evaluation is started from \eqn{M}+\code{startadd} that is from a value \eqn{N} which is strictly greater than the number of observed units. This can be useful when the likelihood has to be evaluated in a large range of \eqn{N} values and a reduced grid is called for.}
 \item{by.incr}{a positive integer. \code{by.incr} represents the increment on the sequence of possible population sizes \eqn{N} where the posterior is evaluated. The default value is \code{by.incr}=1. The use of \code{by.incr}>1 is discouraged unless the range of \eqn{N} values of interest is very large}
 \item{mbc.function}{a character string with possible entries (see Alunni Fegatelli (2013) for further details)
\enumerate{
    \item \code{"standard"} meaningful behavioural covariate in [0,1] obtained through the normalized binary representation of integers relying upon partial capture history
    \item \code{"markov"} slight modification of \code{"standard"} providing consistency with arbitrary Markov order models when used in conjunction with the options \code{"Msubjective"}
and \code{z.cut}. 
    \item \code{"counts"} covariate in [0,1] obtained by normalizing the integer corresponding to the sum of binary entries i.e. the number of previous captures
    \item \code{"integer"} un-normalized integer corresponding to the binary entries of the partial capture history
    \item \code{"counts.integer"} un-normalized covariate obtained as the sum of binary entries i.e. the number of previous captures
  }
}
 \item{mod}{a character. \code{mod} represents the behavioural model considered for the analysis. \code{mod="linear.logistic"} is the model proposed in Alunni Fegatelli (2013) based on the meaningful behavioural covariate. \code{mod="M0"} is the most basic model where no effect is considered and all capture probabilities are the same. \code{mod="Mb"} is the classical behavioural model where the capture probability
varies only once when first capture occurs. Hence it represents 
an \emph{enduring} effect to capture. \code{mod="Mc"} is the \emph{ephemeral} behavioural Markovian model originally introduced in Yang and Chao (2005) and subsequently extended in Farcomeni (2011) and reviewed in Alunni Fegatelli and Tardella (2012) where capture probability depends only on the capture status (captured or uncaptured) in the previous \code{k=markov.ord} occasions. \code{mod="Mcb"} is an extension of Yang and Chao's model (2005); it considers both \emph{ephemeral} and \emph{enduring} effect to capture. \code{mod="Mt"} is the standard temporal effect with no behavioural effect. \code{mod="Msubjective.cut"} is an alternative behavioural model obtained through a specific cut on the meaningful behavioural covariate interpreted as memory effect. \code{mod="Msubjective"} is a customizable (subjective) behavioural model within the linear logistic model framework requiring the specification of the two additional arguments: the first one is \code{meaningful.mat.subjective} and contains an \eqn{M} by \eqn{t} matrix of ad-hoc meaningful covariates depending on previous capture history; the second one is \code{meaningful.mat.new.value.subjective} and contains a vector of length \eqn{t} corresponding to meaningful covariates for a generic uncaptured unit. The default value for \code{mod} is \code{"linear.logistic".}}


   \item{heterogeneity}{a logical. If \code{TRUE} individual heterogeneity effect is considered in the model}
   \item{markov.ord}{a positive integer. \code{markov.ord} is the order of Markovian model \eqn{M_c} or \eqn{M_{cb}}. It is considered only if \code{mod="Mc"} or \code{mod="Mcb"}.}
   \item{meaningful.mat.subjective}{\code{M x t} matrix containing  numerical covariates to be used for a customized logistic model approach}
   \item{meaningful.mat.new.value.subjective}{\code{1 x t} numerical vector corresponding to auxiliary covariate to be considered for unobserved unit}
   \item{z.cut}{numeric vector. \code{z.cut} is a vector containing the cut point for the memory effect covariate. It is considered only if \code{mod="Msubjective.cut"}}
   \item{td.cov}{data frame or matrix with \eqn{k} columns and \eqn{t} rows with each column corresponding to a time-dependent covariate to be used at each capture occasion for any captured/uncaptured unit}
   \item{td.cov.formula}{a character string to be used as additional component in the \code{glm/glmer} formula. Names of each column of \code{td.cov} are forced to be \code{X1}, \code{X2}, ..... See examples when covariates have to be considered as factors. }
   \item{verbose}{a logical. If \code{TRUE} the percentage of likelihood evaluation is printed out while running.}
   \item{graph}{a logical. If \code{TRUE} a plot with the likelihood evaluations is sent to the graphical device. This helps to verify the possible presence of an almost flat profile likelihood for \eqn{N}}
   \item{output}{character. \code{output} select the kind of output from a very basic summary info on the posterior output (point and interval estimates for the unknown \code{N}) to more complete details including the estimates of the nuisance parameters and other features of the fitted model}
}
\details{
The \code{LBRecap} procedure is computing intensive for high values of \code{neval}.
}
\value{
 (if \code{output="complete"}) the function \code{LBRecap} returns a list of: \enumerate{
  \item{Model}{model considered.}
  \item{N.hat}{unconditional maximum likelihood estimate for \eqn{N}} 
  \item{CI}{interval estimate for \eqn{N}}
  \item{AIC}{Akaike information criterion.}
  \item{L.Failure}{Likelihood Failure condition}
  \item{N.range}{values of N considered.}
  \item{log.lik}{values of the log-likelihood distribution for each \eqn{N} considered}
  \item{z.matrix}{meaningful behavioural covariate matrix for the observed data}
  \item{vec.cut}{cut point used to set up meaningful partitions the set of the partial capture histories according to the value of the value of the meaningful behavioural covariate.}
}
}

\references{Alunni Fegatelli, D. and Tardella, L. (2012) Improved inference on capture recapture models with behavioural effects. Statistical Methods & Applications Applications Volume 22, Issue 1, pp 45-66 10.1007/s10260-012-0221-4

Farcomeni A. (2011) Recapture models under equality constraints for the conditional capture probabilities. Biometrika 98(1):237--242
}
\author{Danilo Alunni Fegatelli and Luca Tardella}
%\note{}
\seealso{
\code{\link{LBRecap.custom.part}}, 
\code{\link{LBRecap.all}}, 
\code{\link{BBRecap}}
}
\examples{

data(greatcopper)
mod.Mb=LBRecap(greatcopper,mod="Mb")
str(mod.Mb)

}

% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
%\keyword{}
\keyword{Unconditional MLE}
\keyword{Behavioural models}
