% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BBRecap.custom.part.R
\name{BBRecap.custom.part}
\alias{BBRecap.custom.part}
\title{Bayesian inference for behavioural effect models based on a partition of the set of all partial capture histories}
\usage{
BBRecap.custom.part (data,last.column.count=FALSE, partition, neval = 1000,
   by.incr = 1, prior.N = c("Rissanen", "Uniform", "one.over.N", "one.over.N2"),
   output = c("base", "complete"))
}
\arguments{
\item{data}{can be one of the following: \enumerate{
  \item an \eqn{M} by \eqn{t} binary matrix/data.frame. In this case the input is interpreted as a matrix whose rows contain individual capture histories for all \eqn{M} observed units
  \item a matrix/data.frame with \eqn{(t+1)} columns. The first \eqn{t} columns contain binary entries corresponding to capture occurrences, while the last column contains non negative integers corresponding to frequencies. This format is allowed only when \code{last.column.count} is set to \code{TRUE}
  \item a \eqn{t}-dimensional array or table representing the counts of the \eqn{2^t} contingency table of binary outcomes
}
\eqn{M} is the number of units captured at least once and \eqn{t} is the number of capture occasions.}

\item{last.column.count}{a logical. In the default case \code{last.column.count=FALSE} each row of the input argument \code{data} represents the complete capture history for each observed unit. When \code{last.column.count} is set to \code{TRUE} in each row the first \eqn{t} entries represent one of the observed complete capture histories and the last entry in the last column is the number of observed units with that capture history}

\item{partition}{list. \code{partition} represents a partition of the set of all partial capture histories.}

\item{neval}{a positive integer. \code{neval} is the number of values of the population size \eqn{N} where the posterior is evaluated starting from \eqn{M}. The default value is \code{neval}=1000.}

\item{by.incr}{a positive integer. \code{by.incr} represents the increment on the sequence of possible population sizes \eqn{N} where the posterior is evaluated. The default value is \code{by.incr}=1. The use of \code{by.incr}>1 is discouraged unless the range of \eqn{N} values of interest is very large}

\item{prior.N}{a character. \code{prior.N} is the label for the prior distribution for \eqn{N}. When \code{prior.N} is set to \code{"Rissanen"} (default) the Rissanen prior is used as a prior on \eqn{N}. This distribution was first proposed in Rissanen 1983 as a universal prior on integers. \code{prior.N="Uniform"} stands for a prior on \eqn{N} proportional to a constant value. \code{prior.N="one.over.N"} stands for a prior on \eqn{N} proportional to \eqn{1/N}. \code{prior.N="one.over.N2"} stands for a prior on \eqn{N} proportional to \eqn{1/N^2}.}

\item{output}{a character. \code{output} selects the kind of output from a very basic summary info on the posterior output (point and interval estimates for the unknown \eqn{N}) to more complete details}
}
\value{
\item{Prior}{prior distribution for \code{N}.}
\item{N.hat.mean}{posterior mean for \eqn{N}}
\item{N.hat.median}{posterior median for \eqn{N}}
\item{N.hat.mode}{posterior mode for \eqn{N}}
\item{N.hat.RMSE}{minimizer of a specific loss function connected with the Relative Mean Square Error.}
\item{HPD.N}{\eqn{95 \%} highest posterior density interval estimate for \eqn{N}.}
\item{log.marginal.likelihood}{log marginal likelihood.}
\item{N.range}{values of N considered.}
\item{posterior.N}{values of the posterior distribution for each N considered}
\item{partition}{partition of the set H}
}
\description{
Bayesian inference for a general model framework based on the capture probabilities conditioned on each possible partial capture history.  As suggested in Alunni Fegatelli and Tardella (2012) the conditional approach originally proposed in Farcomeni (2011)  [saturated reparameterization] is reviewed in terms of partitions into equivalence classes of conditional probabilities. In this function the user can directly provide the model as a partition.
}
\details{
Uniform prior distribution is considered for the nuisance parameters.
}
\examples{

data(greatcopper)
partition.Mc1=partition.ch(quant.binary,t=ncol(greatcopper),breaks=c(0,0.5,1))
mod.Mc1=BBRecap.custom.part(greatcopper,partition=partition.Mc1)
str(mod.Mc1)

}
\references{
Farcomeni A. (2011) Recapture models under equality constraints for the conditional capture probabilities. Biometrika 98(1):237--242

Alunni Fegatelli, D. and Tardella, L. (2012) Improved inference on capture recapture models with behavioural effects. Statistical Methods & Applications Applications Volume 22, Issue 1, pp 45-66 10.1007/s10260-012-0221-4

Alunni Fegatelli D. (2013) New methods for capture-recapture modelling with behavioural response and individual heterogeneity. http://hdl.handle.net/11573/918752
}
\seealso{
\code{\link{partition.ch}}, \code{\link{LBRecap.custom.part}}, \code{\link{BBRecap}}
}
\author{
Danilo Alunni Fegatelli and Luca Tardella
}
\keyword{Bayesian_inference}
\keyword{Behavioural_models}
