% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Vaccine}
\alias{Vaccine}
\alias{c.pts}
\alias{cost.GP}
\alias{cost.hosp}
\alias{cost.otc}
\alias{cost.time.off}
\alias{cost.time.vac}
\alias{cost.travel}
\alias{cost.trt1}
\alias{cost.trt2}
\alias{cost.vac}
\alias{e.pts}
\alias{N}
\alias{N.outcomes}
\alias{N.resources}
\alias{QALYs.adv}
\alias{QALYs.death}
\alias{QALYs.hosp}
\alias{QALYs.inf}
\alias{QALYs.pne}
\alias{vaccine}
\alias{vaccine_mat}
\title{Data set for the Bayesian model for the cost-effectiveness of influenza
vaccination}
\format{
A data list including the variables needed for the influenza
vaccination. The variables are as follows:
\describe{
\item{list("cost")}{a matrix of simulations from the posterior
distribution of the overall costs associated with the two treatments}
\item{list("c.pts")}{}
\item{list("cost.GP")}{a matrix of simulations from the posterior
distribution of the costs for GP visits associated with the two treatments}
\item{list("cost.hosp")}{a matrix of simulations from the posterior
distribution of the costs for hospitalisations associated with the two
treatments}
\item{list("cost.otc")}{a matrix of simulations from the posterior distribution
of the costs for over-the-counter medications associated with the two treatments}
\item{list("cost.time.off")}{a matrix of simulations from the posterior
distribution of the costs for time off work associated with the two treatments}
\item{list("cost.time.vac")}{a matrix of simulations from the posterior
distribution of the costs for time needed to get the vaccination associated
with the two treatments}
\item{list("cost.travel")}{a matrix of simulations from the posterior
distribution of the costs for travel to get vaccination associated with the
two treatments}
\item{list("cost.trt1")}{a matrix of simulations from the
posterior distribution of the overall costs for first line of treatment
associated with the two interventions}
\item{list("cost.trt2")}{a matrix of simulations from the posterior distribution
of the overall costs for second line of treatment associated with the two
interventions}
\item{list("cost.vac")}{a matrix of simulations from the posterior
distribution of the costs for vaccination}
\item{list("eff")}{a matrix of simulations from the posterior distribution of
the clinical benefits associated with the two treatments}
\item{list("e.pts")}{}
\item{list("N")}{the number of subjects in the reference population}
\item{list("N.outcomes")}{the number of clinical outcomes analysed}
\item{list("N.resources")}{the number of health-care resources under study}
\item{list("QALYs.adv")}{a vector from the posterior distribution of the
QALYs associated with advert events}
\item{list("QALYs.death")}{a vector from the posterior distribution of the
QALYs associated with death}
\item{list("QALYs.hosp")}{a vector from the posterior distribution of the
QALYs associated with hospitalisation}
\item{list("QALYs.inf")}{a vector from the posterior distribution of the
QALYs associated with influenza infection}
\item{list("QALYs.pne")}{a vector from the posterior distribution of the
QALYs associated with pneumonia}
\item{list("treats")}{a vector of labels associated with the two treatments}
\item{list("vaccine_mat")}{a matrix containing the simulations for the
parameters used in the original model}
}
}
\source{
Adapted from Turner D, Wailoo A, Cooper N, Sutton A, Abrams K,
Nicholson K. The cost-effectiveness of influenza vaccination of healthy
adults 50-64 years of age. Vaccine. 2006;24:1035-1043.
}
\description{
This data set contains the results of the Bayesian analysis used to model
the clinical output and the costs associated with an influenza vaccination.
}
\references{
Baio, G., Dawid, A. P. (2011). Probabilistic Sensitivity
Analysis in Health Economics. Statistical Methods in Medical Research
doi:10.1177/0962280211419832.
}
\keyword{datasets}
