% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exploreConvPath.R
\name{exploreConvPath}
\alias{exploreConvPath}
\title{Explore the shortest convertion path between two identifiers}
\usage{
exploreConvPath(
  from.id,
  to.id,
  from,
  from.source,
  to,
  to.source,
  edgeDirection = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{from.id}{the first identifier}

\item{to.id}{the second identifier}

\item{from}{the type of entity: \code{listBe()} or Probe.
\strong{Guessed if not provided}}

\item{from.source}{the identifier source: database or platform.
\strong{Guessed if not provided}}

\item{to}{the type of entity: \code{listBe()} or Probe.
\strong{Guessed if not provided}}

\item{to.source}{the identifier source: database or platform.
\strong{Guessed if not provided}}

\item{edgeDirection}{a logical value indicating if the direction of the
edges should be drawn.}

\item{verbose}{if TRUE the cypher query is shown}
}
\description{
This function uses visNetwork to draw all the shortest convertion paths
between two identifiers (including ProbeID).
}
\examples{
\dontrun{
exploreConvPath(
   from.id="ENST00000413465",
   from="Transcript", from.source="Ens_transcript",
   to.id="ENSMUST00000108658",
   to="Transcript", to.source="Ens_transcript"
)
}

}
