% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{bfs_search}
\alias{bfs_search}
\title{Search titles of available BFS datasets}
\usage{
bfs_search(string, data = bfs_get_metadata(), ignore.case = TRUE)
}
\arguments{
\item{string}{A regular expression string to search for.}

\item{data}{The data frame to search. This can be either a data frame
previously fetched using \code{\link{bfs_get_metadata}} (recommended) or left
blank, in which case a temporary data frame is fetched. The second option
adds a few seconds to each search query.}

\item{ignore.case}{Whether the search should be case-insensitive.}
}
\value{
A data frame.
}
\description{
Returns a tibble containing the titles, publication date,
observation periods, metadata url and download urls of
available BFS datasets in a given language which match
the given criteria.
}
\examples{
\donttest{df_en <- bfs_get_metadata(language = "en")}
\donttest{bfs_search("education", df_en)}

}
\seealso{
\code{\link{bfs_get_metadata}}
}
